/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.ase;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.persistence.commands.ase.AbstractCommandWithDBId;
import com.sap.core.tunnelcommands.framework.executor.CommandTunnelRequestExecutor;
import com.sap.core.tunnelcommands.framework.executor.DefaultResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpClientProvider;
import com.sap.core.tunnelcommands.framework.executor.HttpPutStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseContext;
import com.sap.core.tunnelcommands.framework.executor.HttpUriRequestStrategy;
import com.sap.core.tunnelcommands.framework.executor.ICommandTunnelCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;

@Parameters(commandDescription="Changes the properties for an ASE database.")
public class SetDBPropertiesCommand
extends AbstractCommandWithDBId {
    private static final String SET_DB_PROPERTIES = "set-db-properties-ase";
    @Parameter(names={"--db-size"}, description="New size of the database in MB. New size must be greater than the actual size.", required=true)
    private String dbSizeParameter;

    @Override
    public void init() throws CommandException {
        this.checkArgAccount();
        this.checkArgId();
        this.checkArgDbSize();
        super.init();
    }

    private void checkArgDbSize() {
        CheckHelper.checkArgSpecified((String)"--db-size", (String)"--db-size", (String)this.dbSizeParameter);
    }

    public String getGroup() {
        return "persistence";
    }

    public String getName() {
        return SET_DB_PROPERTIES;
    }

    public void run() throws CommandException {
        HttpPutStrategy restCallStrategy = new HttpPutStrategy();
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor((HttpUriRequestStrategy)restCallStrategy, (HttpResponseConsumingStrategy)new SetDBPropertyConsumer(), (ICommandTunnelCommand)this, "ase/databases/" + HttpClientProvider.encodeURLString((String)this.databaseId) + "/properties/databaseSize/" + HttpClientProvider.encodeURLString((String)this.dbSizeParameter));
        helper.executeRequest();
    }

    private class SetDBPropertyConsumer
    extends DefaultResponseConsumingStrategy {
        private SetDBPropertyConsumer() {
        }

        public void consume(HttpResponseContext context) throws CommandException {
            int statusCode = context.getResponse().getStatusLine().getStatusCode();
            if (statusCode == 200) {
                System.out.println("Database size increased to " + SetDBPropertiesCommand.this.dbSizeParameter + " MB.");
            } else if (statusCode == 202) {
                System.out.println("Request to increase size of ASE database '" + SetDBPropertiesCommand.this.databaseId + "' to '" + SetDBPropertiesCommand.this.dbSizeParameter + "' MB is accepted. The request will be processed asynchronously. To check the status of this request you may use display-db-info command.");
            } else if (statusCode == 409 || statusCode == 400) {
                this.throwCommandExceptionWithContentInfoAndLog(null, context);
            } else {
                super.consume(context);
            }
        }
    }
}

