/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.entities;

import com.sap.core.persistence.commands.entities.BindingInfoEntity;
import com.sap.core.persistence.commands.entities.EventLogEntryEntity;
import com.sap.core.persistence.commands.hana.HanaConstants;

public class DbsInfoEntity {
    private String databaseId;
    private String dbState;
    private ConfigurationParameters parameters;
    private int dbSizeInMB;
    private DatabaseDetails details;
    private String dbType;
    private String dbVersion;
    private String dbSystemName;
    private String rootURL;
    private BindingInfoEntity[] bindings;
    private EventLogEntryEntity[] eventLogEntries;

    public DbsInfoEntity() {
    }

    public DbsInfoEntity(String databaseId, String dbState, String dbType, String dbVersion, BindingInfoEntity[] bindings) {
        this.databaseId = databaseId;
        this.dbState = dbState;
        this.dbType = dbType;
        this.dbVersion = dbVersion;
        this.bindings = bindings;
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public void setDatabaseId(String databaseId) {
        this.databaseId = databaseId;
    }

    public String getDbState() {
        return this.dbState;
    }

    public void setDbState(String dbState) {
        this.dbState = dbState;
    }

    public ConfigurationParameters getParameters() {
        return this.parameters;
    }

    public void setParameters(ConfigurationParameters parameters) {
        this.parameters = parameters;
    }

    public DatabaseDetails getDetails() {
        return this.details;
    }

    public void setDetails(DatabaseDetails details) {
        this.details = details;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public String getDbVersion() {
        return this.dbVersion;
    }

    public void setDbVersion(String dbVersion) {
        this.dbVersion = dbVersion;
    }

    public String getDbSystemName() {
        return this.dbSystemName;
    }

    public void setDbSystemName(String dbSystemName) {
        this.dbSystemName = dbSystemName;
    }

    public BindingInfoEntity[] getBindings() {
        return (BindingInfoEntity[])this.bindings.clone();
    }

    public void setBindings(BindingInfoEntity[] bindings) {
        this.bindings = bindings;
    }

    public EventLogEntryEntity[] getEventLogEntries() {
        return (EventLogEntryEntity[])this.eventLogEntries.clone();
    }

    public void setEventLogEntries(EventLogEntryEntity[] eventLogEntries) {
        this.eventLogEntries = eventLogEntries;
    }

    public String getRootURL() {
        return this.rootURL;
    }

    public void setRootURL(String rootURL) {
        this.rootURL = rootURL;
    }

    public int getDbSizeInMB() {
        return this.dbSizeInMB;
    }

    public void setDbSizeInMB(int dbSizeInMB) {
        this.dbSizeInMB = dbSizeInMB;
    }

    public static class DatabaseDetails {
        public String effectiveIndexserverAllocationLimitMiB;
        public String effectiveXsengineAllocationLimitMiB;
        public Long dbSizeDataUsed;

        public String getEffectiveIndexserverAllocationLimitMiB() {
            return this.effectiveIndexserverAllocationLimitMiB;
        }

        public String getEffectiveXsengineAllocationLimitMiB() {
            return this.effectiveXsengineAllocationLimitMiB;
        }

        public Long getDbSizeDataUsed() {
            return this.dbSizeDataUsed;
        }
    }

    public static class ConfigurationParameters {
        public String dbPassword;
        public String indexserverAllocationLimit;
        public String indexserverMaxConcurrency;
        public String xsengineAllocationLimit;
        public String xsengineMaxConcurrency;
        public HanaConstants.WebAccessMode webAccessMode;
        public HanaConstants.XsEngineMode xsEngineMode;
        public HanaConstants.DatabaseRunMode dbRunMode;
        public Long dbSizeDataTotal;

        public String getDbPassword() {
            return this.dbPassword;
        }

        public String getIndexserverAllocationLimit() {
            return this.indexserverAllocationLimit;
        }

        public String getIndexserverMaxConcurrency() {
            return this.indexserverMaxConcurrency;
        }

        public String getXsengineAllocationLimit() {
            return this.xsengineAllocationLimit;
        }

        public String getXsengineMaxConcurrency() {
            return this.xsengineMaxConcurrency;
        }

        public HanaConstants.WebAccessMode getWebAccessMode() {
            return this.webAccessMode;
        }

        public HanaConstants.XsEngineMode getXsEngineMode() {
            return this.xsEngineMode;
        }

        public HanaConstants.DatabaseRunMode getDbRunMode() {
            return this.dbRunMode;
        }

        public Long getDbSizeDataTotal() {
            return this.dbSizeDataTotal;
        }
    }
}

