/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.hana;

import com.beust.jcommander.Parameter;
import com.google.gson.JsonObject;
import com.sap.core.persistence.commands.AbstractAccountCommand;
import com.sap.core.persistence.commands.entities.DbsInfoEntity;
import com.sap.core.tunnelcommands.framework.executor.CommandTunnelRequestExecutor;
import com.sap.core.tunnelcommands.framework.executor.HttpClientProvider;
import com.sap.core.tunnelcommands.framework.executor.HttpPutStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseContext;
import com.sap.core.tunnelcommands.framework.executor.HttpUriRequestStrategy;
import com.sap.core.tunnelcommands.framework.executor.ICommandTunnelCommand;
import com.sap.core.tunnelcommands.framework.executor.JsonConsumingStrategy;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;

public abstract class AbstractDbHanaCommand
extends AbstractAccountCommand {
    @Parameter(names={"-i", "--id"}, description="HANA database ID. Starts with a letter and contains 'a' - 'z' and '0' - '9'.")
    private String id;

    @Override
    public void init() throws CommandException {
        CheckHelper.checkArgSpecified((String)"-i", (String)"--id", (String)this.getId());
        super.init();
    }

    @Override
    public void cleanup() throws CommandException {
    }

    public String getGroup() {
        return "persistence";
    }

    public void run() throws CommandException {
        HttpPutStrategy restCallStrategy = new HttpPutStrategy(this.getCommandParamsAsJson());
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor((HttpUriRequestStrategy)restCallStrategy, (HttpResponseConsumingStrategy)new DisplayDbsInfoConsumer(), (ICommandTunnelCommand)this, "hana/databases/" + HttpClientProvider.encodeURLString((String)this.getId()));
        helper.executeRequest();
    }

    protected abstract JsonObject getCommandParamsAsJson();

    protected abstract void printResult(DbsInfoEntity var1);

    protected String getId() {
        return this.id;
    }

    protected class DisplayDbsInfoConsumer
    extends JsonConsumingStrategy<DbsInfoEntity> {
        protected DisplayDbsInfoConsumer() {
            super(DbsInfoEntity.class);
        }

        public void consume(HttpResponseContext context) throws CommandException {
            int statusCode = context.getStatusCode();
            if (statusCode == 202) {
                AbstractDbHanaCommand.this.printResult((DbsInfoEntity)this.getJsonObject(context));
            } else if (context.getStatusCode() == 404) {
                this.throwCommandExceptionWithContentInfoAndLog(null, context);
            } else {
                super.consume(context);
            }
        }
    }
}

