/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.hana;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.google.gson.JsonObject;
import com.sap.core.persistence.commands.AbstractAccountCommand;
import com.sap.core.persistence.commands.hana.HanaConstants;
import com.sap.core.tunnelcommands.framework.executor.CommandTunnelRequestExecutor;
import com.sap.core.tunnelcommands.framework.executor.DefaultResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpPostStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseContext;
import com.sap.core.tunnelcommands.framework.executor.HttpUriRequestStrategy;
import com.sap.core.tunnelcommands.framework.executor.ICommandTunnelCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;
import java.io.Console;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

@Parameters(commandDescription="BETA: Creates a HANA database with the specified ID and settings on a HANA database system")
public class CreateDatabaseHana
extends AbstractAccountCommand {
    private static final Pattern HANA_DATABASE_ID_PATTERN = Pattern.compile("[a-z][a-z0-9]*");
    private static final String DB_SYSTEM_TRIAL = "-TRIAL-";
    @Parameter(names={"-i", "--id"}, description="HANA database ID. Starts with a letter and contains 'a' - 'z' and '0' - '9'.")
    private String idParameter;
    static final String CREATE_DATABASE_HANA_COMMAND_NAME = "create-db-hana";
    Logger LOGGER = Logger.getLogger(CreateDatabaseHana.class);
    @Parameter(names={"--dbsystem"}, description="ID of a productive HANA database system or -trial-.")
    private String dbSystemParameter;
    @Parameter(names={"--db-password"}, description="The password of the SYSTEM user for the HANA database (optional, queried at the command prompt if omitted).", required=false)
    private String dbPasswordParameter = null;
    @Parameter(names={"--web-access"}, description="Enables or disables access to the HANA database from the Internet: 'enabled' (default), 'disabled'.", required=false)
    private String webAccessModeParameter = null;
    @Parameter(names={"--dp-server"}, description="Enables or disables the data processing server of the HANA database: 'enabled', 'disabled' (default).", required=false)
    private String dpServerModeParameter = null;
    @Parameter(names={"--script-server"}, description="Enables or disables the script server of the HANA database: 'enabled', 'disabled' (default).", required=false)
    private String scriptServerModeParameter = null;
    @Parameter(names={"--xsengine-mode"}, description="Specifies how the XS engine should run: 'embedded' (default), 'standalone'.", required=false)
    private String xsengineModeParameter = null;
    private boolean createTrialInstance = false;
    private String webAccessModeValue = null;
    private String dpServerModeValue = null;
    private String scriptServerModeValue = null;
    private String xsengineModeValue = null;

    @Override
    public void init() throws CommandException {
        this.checkArgAccount();
        this.checkArgId();
        this.checkArgDbSystem();
        this.checkArgWebAccessMode();
        this.checkArgDpServerMode();
        this.checkArgScriptServerMode();
        this.checkArgXsengineMode();
        super.init();
    }

    private void checkArgId() {
        CheckHelper.checkArgSpecified((String)"-i", (String)"--id", (String)this.idParameter);
        if (!HANA_DATABASE_ID_PATTERN.matcher(this.idParameter).matches()) {
            throw new ParameterException("Invalid HANA database ID '" + this.idParameter + "'. A valid ID must start with a letter and can only contain 'a' - 'z' and '0' - '9'.");
        }
    }

    private void checkArgDbSystem() {
        CheckHelper.checkArgSpecified(null, (String)"--dbsystem", (String)this.dbSystemParameter);
        if (DB_SYSTEM_TRIAL.equalsIgnoreCase(this.dbSystemParameter)) {
            this.createTrialInstance = true;
        }
    }

    private void checkArgWebAccessMode() {
        if (this.webAccessModeParameter != null) {
            if ("enabled".equals(this.webAccessModeParameter)) {
                this.webAccessModeValue = HanaConstants.WebAccessMode.ENABLED.name();
            } else if ("disabled".equals(this.webAccessModeParameter)) {
                this.webAccessModeValue = HanaConstants.WebAccessMode.DISABLED.name();
            } else {
                throw new ParameterException("--web-access must be either 'enabled' or 'disabled'.");
            }
        }
    }

    private void checkArgDpServerMode() {
        if (this.dpServerModeParameter != null) {
            if ("enabled".equals(this.dpServerModeParameter)) {
                this.dpServerModeValue = HanaConstants.DpServerMode.ENABLED.name();
            } else if ("disabled".equals(this.dpServerModeParameter)) {
                this.dpServerModeValue = HanaConstants.DpServerMode.DISABLED.name();
            } else {
                throw new ParameterException("--dp-server must be either 'enabled' or 'disabled'.");
            }
        }
    }

    private void checkArgScriptServerMode() {
        if (this.scriptServerModeParameter != null) {
            if ("enabled".equals(this.scriptServerModeParameter)) {
                this.scriptServerModeValue = HanaConstants.ScriptServerMode.ENABLED.name();
            } else if ("disabled".equals(this.scriptServerModeParameter)) {
                this.scriptServerModeValue = HanaConstants.ScriptServerMode.DISABLED.name();
            } else {
                throw new ParameterException("--script-server must be either 'enabled' or 'disabled'.");
            }
        }
    }

    private void checkArgXsengineMode() {
        if (this.xsengineModeParameter != null) {
            if (this.createTrialInstance) {
                throw new ParameterException("When creating a Trial HANA database, the parameter '--xsengine-mode' must not be provided");
            }
            if ("embedded".equals(this.xsengineModeParameter)) {
                this.xsengineModeValue = HanaConstants.XsEngineMode.EMBEDDED.name();
            } else if ("standalone".equals(this.xsengineModeParameter)) {
                this.xsengineModeValue = HanaConstants.XsEngineMode.STANDALONE.name();
            } else {
                throw new ParameterException("--xsengine-mode must be either 'embedded' or 'standalone'.");
            }
        }
    }

    public String getGroup() {
        return "persistence";
    }

    public String getName() {
        return CREATE_DATABASE_HANA_COMMAND_NAME;
    }

    public void run() throws CommandException {
        this.checkPassword();
        HttpPostStrategy restCallStrategy = new HttpPostStrategy(this.getCommandParamsAsJson());
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor((HttpUriRequestStrategy)restCallStrategy, (HttpResponseConsumingStrategy)new CreateDatabaseConsumer(), (ICommandTunnelCommand)this, "hana/databases/");
        helper.executeRequest();
    }

    private JsonObject getCommandParamsAsJson() {
        JsonObject props = new JsonObject();
        props.addProperty("databaseId", this.idParameter);
        if (this.createTrialInstance) {
            props.addProperty("trialInstance", "true");
        } else {
            props.addProperty("dbSystem", this.dbSystemParameter);
        }
        props.addProperty("dbPassword", this.dbPasswordParameter);
        if (this.webAccessModeValue != null) {
            props.addProperty("webAccessMode", this.webAccessModeValue);
        }
        if (this.dpServerModeValue != null) {
            props.addProperty("dpServerMode", this.dpServerModeValue);
        }
        if (this.scriptServerModeValue != null) {
            props.addProperty("scriptServerMode", this.scriptServerModeValue);
        }
        if (this.xsengineModeValue != null) {
            props.addProperty("xsEngineMode", this.xsengineModeValue);
        }
        return props;
    }

    private void checkPassword() {
        if (this.dbPasswordParameter == null || this.dbPasswordParameter.trim().isEmpty()) {
            this.getPassword();
            String passwordRepeated = null;
            Console cons = System.console();
            if (cons != null) {
                char[] passwd2;
                char[] passwd1 = cons.readPassword("%s", "Password for HANA database SYSTEM user: ");
                if (passwd1 != null && passwd1.length > 0) {
                    this.dbPasswordParameter = new String(passwd1);
                }
                if ((passwd2 = cons.readPassword("%s", "Repeat password for HANA database SYSTEM user: ")) != null && passwd2.length > 0) {
                    passwordRepeated = new String(passwd2);
                }
            }
            if (this.dbPasswordParameter == null || this.dbPasswordParameter.trim().isEmpty()) {
                throw new ParameterException("Parameter '--db-password' must be specified");
            }
            if (!this.dbPasswordParameter.equals(passwordRepeated)) {
                throw new ParameterException("The password and the repeated password must be identical.");
            }
        }
    }

    private class CreateDatabaseConsumer
    extends DefaultResponseConsumingStrategy {
        private CreateDatabaseConsumer() {
        }

        public void consume(HttpResponseContext context) throws CommandException {
            int statusCode = context.getResponse().getStatusLine().getStatusCode();
            if (statusCode == 202) {
                String dbSystemInfo = CreateDatabaseHana.this.createTrialInstance ? "a HANA trial system" : "HANA system '" + CreateDatabaseHana.this.dbSystemParameter + "'";
                System.out.println("Request to create HANA tenant database '" + CreateDatabaseHana.this.idParameter + "' as part of " + dbSystemInfo + " is accepted. The request should be processed within next 10-20 minutes. To check the status of this request you may use display-db-info command.");
            } else if (statusCode == 409 || statusCode == 400) {
                this.throwCommandExceptionWithContentInfoAndLog(null, context);
            } else {
                super.consume(context);
            }
        }
    }
}

