/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.hana;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.persistence.commands.AbstractAccountCommand;
import com.sap.core.persistence.commands.entities.DbTunnelAccessTokenResponse;
import com.sap.core.persistence.commands.entities.DbsInfoEntity;
import com.sap.core.tunnelcommands.framework.executor.CommandExecutionContext;
import com.sap.core.tunnelcommands.framework.executor.CommandTunnelRequestExecutor;
import com.sap.core.tunnelcommands.framework.executor.DefaultResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpClientProvider;
import com.sap.core.tunnelcommands.framework.executor.HttpDeleteStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpGetStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseContext;
import com.sap.core.tunnelcommands.framework.executor.HttpUriRequestStrategy;
import com.sap.core.tunnelcommands.framework.executor.ICommandTunnelCommand;
import com.sap.core.tunnelcommands.framework.executor.JsonConsumingStrategy;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;
import java.io.Console;
import java.util.List;
import org.apache.log4j.Logger;

@Parameters(commandDescription="BETA: Deletes the HANA database with the specified ID")
public class DeleteDatabaseHana
extends AbstractAccountCommand {
    @Parameter(names={"-i", "--id"}, description="HANA database ID.")
    private String idParameter;
    static final String DELETE_DATABASE_HANA_COMMAND_NAME = "delete-db-hana";
    Logger LOGGER = Logger.getLogger(DeleteDatabaseHana.class);
    @Parameter(names={"-f", "--force"}, description="(optional) Forcefully deletes the HANA database, including all application bindings.", required=false)
    private boolean forceParameter = false;
    @Parameter(names={"--silent"}, description="(optional) Suppresses the command line confirmation prompt", required=false)
    private boolean silentParameter = false;

    @Override
    public void init() throws CommandException {
        this.checkArgAccount();
        this.checkArgId();
        super.init();
    }

    private void checkArgId() {
        CheckHelper.checkArgSpecified((String)"-i", (String)"--id", (String)this.idParameter);
    }

    public String getGroup() {
        return "persistence";
    }

    public String getName() {
        return DELETE_DATABASE_HANA_COMMAND_NAME;
    }

    public void run() throws CommandException {
        CommandExecutionContext context = new CommandExecutionContext();
        if (this.silentParameter || this.userConfirm()) {
            if (this.forceParameter || this.isDeletionAllowed(context)) {
                HttpDeleteStrategy restCallStrategy = new HttpDeleteStrategy();
                CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor(context, (HttpUriRequestStrategy)restCallStrategy, (HttpResponseConsumingStrategy)new DeleteDatabaseConsumer(), (ICommandTunnelCommand)this, "hana/databases/" + this.idParameter);
                helper.executeRequest();
            }
        } else {
            throw new CommandException("User declined the deletion.", 50);
        }
    }

    private boolean userConfirm() {
        Console console = System.console();
        if (console == null) {
            throw new CommandException("No console available. Please use parameter --silent to force the deletion.", 167);
        }
        System.out.println("Are you sure you want to permanently delete the HANA database '" + this.idParameter + "'? This operation cannot be reverted. (yes/no) ");
        String answer = console.readLine().toLowerCase();
        return "yes".equals(answer) || "y".equals(answer);
    }

    private boolean isDeletionAllowed(CommandExecutionContext context) {
        CheckIfBindingsExistConsumer bindingConsumer = new CheckIfBindingsExistConsumer();
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor(context, (HttpUriRequestStrategy)new HttpGetStrategy(), (HttpResponseConsumingStrategy)bindingConsumer, (ICommandTunnelCommand)this, "hana/databases/" + HttpClientProvider.encodeURLString((String)this.idParameter));
        helper.executeRequest();
        if (bindingConsumer.isExistBindings()) {
            return false;
        }
        CheckIfDbTunnelAccessTokensExistConsumer accessTokenConsumer = new CheckIfDbTunnelAccessTokensExistConsumer();
        helper = new CommandTunnelRequestExecutor(context, (HttpUriRequestStrategy)new HttpGetStrategy(), (HttpResponseConsumingStrategy)accessTokenConsumer, (ICommandTunnelCommand)this, "dbtunnelaccesstokens/" + HttpClientProvider.encodeURLString((String)this.idParameter));
        helper.executeRequest();
        return !accessTokenConsumer.isExistTokens();
    }

    private class CheckIfDbTunnelAccessTokensExistConsumer
    extends JsonConsumingStrategy<DbTunnelAccessTokenResponse> {
        private Boolean isExistTokens;

        public CheckIfDbTunnelAccessTokensExistConsumer() {
            super(DbTunnelAccessTokenResponse.class);
            this.isExistTokens = null;
        }

        public void consume(HttpResponseContext context) throws CommandException {
            if (context.getStatusCode() == 200) {
                this.determineIfDeletionAllowed(this.getJsonArray(context));
            } else if (context.getStatusCode() == 404) {
                this.throwCommandExceptionWithContentInfoAndLog(null, null, context, "HANA database '" + DeleteDatabaseHana.this.idParameter + "' doesn't exist.");
            } else {
                super.consume(context);
            }
        }

        private void determineIfDeletionAllowed(List<DbTunnelAccessTokenResponse> responseList) {
            if (responseList == null || responseList.size() == 0) {
                this.isExistTokens = false;
                return;
            }
            String message = "HANA database '" + DeleteDatabaseHana.this.idParameter + "' cannot be deleted because there are still existing db tunnel access tokens. Remove them all before deleting the database or use the " + "--force" + " parameter.";
            System.out.println(message);
            this.isExistTokens = true;
        }

        private boolean isExistTokens() {
            return this.isExistTokens;
        }
    }

    private class CheckIfBindingsExistConsumer
    extends JsonConsumingStrategy<DbsInfoEntity> {
        private Boolean isExistBindings;

        public CheckIfBindingsExistConsumer() {
            super(DbsInfoEntity.class);
            this.isExistBindings = null;
        }

        public void consume(HttpResponseContext context) throws CommandException {
            if (context.getStatusCode() == 200) {
                this.determineIfDeletionAllowed((DbsInfoEntity)this.getJsonObject(context));
            } else if (context.getStatusCode() == 404) {
                this.throwCommandExceptionWithContentInfoAndLog(null, null, context, "HANA database '" + DeleteDatabaseHana.this.idParameter + "' doesn't exist.");
            } else {
                super.consume(context);
            }
        }

        private void determineIfDeletionAllowed(DbsInfoEntity dbsInfo) {
            if (dbsInfo.getBindings() == null || dbsInfo.getBindings().length == 0) {
                this.isExistBindings = false;
                return;
            }
            String message = "HANA database '" + DeleteDatabaseHana.this.idParameter + "' cannot be deleted because there are still bindings to it. Unbind all the applications before deleting the database or use the " + "--force" + " parameter.";
            System.out.println(message);
            this.isExistBindings = true;
        }

        private boolean isExistBindings() {
            return this.isExistBindings;
        }
    }

    private class DeleteDatabaseConsumer
    extends DefaultResponseConsumingStrategy {
        private DeleteDatabaseConsumer() {
        }

        public void consume(HttpResponseContext context) throws CommandException {
            int statusCode = context.getResponse().getStatusLine().getStatusCode();
            if (statusCode == 202) {
                System.out.println("Request to delete database '" + DeleteDatabaseHana.this.idParameter + "' accepted.");
            } else if (statusCode == 404 || statusCode == 400) {
                this.throwCommandExceptionWithContentInfoAndLog(null, context);
            } else {
                super.consume(context);
            }
        }
    }
}

