/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.hana;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.google.gson.JsonObject;
import com.sap.core.persistence.commands.entities.DbsInfoEntity;
import com.sap.core.persistence.commands.hana.AbstractDbHanaCommand;
import com.sap.core.persistence.commands.hana.HanaConstants;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.io.Console;

@Parameters(commandDescription="BETA: Changes HANA database properties")
public class SetDbPropertiesHanaCommand
extends AbstractDbHanaCommand {
    @Parameter(names={"--web-access"}, description="Enables or disables access to the HANA database from the Internet: 'enabled' (default), 'disabled' (optional, current value unchanged if omitted)")
    private String webAccessModeParameter = null;
    @Parameter(names={"--xsengine-mode"}, description="Specifies how the XS engine should run: 'embedded' (default), 'standalone' (optional, current value unchanged if omitted)")
    private String xsengineModeParameter = null;
    static final String SET_DB_PROPERTIES_HANA_COMMAND_NAME = "set-db-properties-hana";
    private String webAccessModeValue = null;
    private String xsengineModeValue = null;

    public String getName() {
        return SET_DB_PROPERTIES_HANA_COMMAND_NAME;
    }

    @Override
    public void init() throws CommandException {
        this.checkArgWebAccessMode();
        this.checkArgXsengineMode();
        if (this.webAccessModeValue == null && this.xsengineModeValue == null) {
            throw new ParameterException("At least one property must be set: --web-access or --xsengine-mode");
        }
        super.init();
    }

    @Override
    public void run() throws CommandException {
        if (this.userConfirm()) {
            super.run();
        }
    }

    @Override
    protected JsonObject getCommandParamsAsJson() {
        JsonObject props = new JsonObject();
        if (this.webAccessModeValue != null) {
            props.addProperty("webAccessMode", this.webAccessModeValue);
        }
        if (this.xsengineModeValue != null) {
            props.addProperty("xsEngineMode", this.xsengineModeValue);
        }
        return props;
    }

    @Override
    protected void printResult(DbsInfoEntity info) {
        System.out.println("Request to set properties for HANA database '" + this.getId() + "' accepted.");
    }

    private boolean userConfirm() {
        if (this.xsengineModeParameter == null) {
            return true;
        }
        Console cons = System.console();
        if (cons == null) {
            return true;
        }
        System.out.println("HANA database '" + this.getId() + "' will be restarted when changing XS engine mode. Do you want to proceed? (yes/no)");
        String answer = cons.readLine().toLowerCase();
        return "yes".equals(answer) || "y".equals(answer);
    }

    private void checkArgWebAccessMode() {
        if (this.webAccessModeParameter != null) {
            if ("enabled".equals(this.webAccessModeParameter)) {
                this.webAccessModeValue = HanaConstants.WebAccessMode.ENABLED.name();
            } else if ("disabled".equals(this.webAccessModeParameter)) {
                this.webAccessModeValue = HanaConstants.WebAccessMode.DISABLED.name();
            } else {
                throw new ParameterException("--web-access must be either 'enabled' or 'disabled'.");
            }
        }
    }

    private void checkArgXsengineMode() {
        if (this.xsengineModeParameter != null) {
            if ("embedded".equals(this.xsengineModeParameter)) {
                this.xsengineModeValue = HanaConstants.XsEngineMode.EMBEDDED.name();
            } else if ("standalone".equals(this.xsengineModeParameter)) {
                this.xsengineModeValue = HanaConstants.XsEngineMode.STANDALONE.name();
            } else {
                throw new ParameterException("--xsengine-mode must be either 'embedded' or 'standalone'.");
            }
        }
    }
}

