/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.hanaxs;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.gson.JsonObject;
import com.sap.core.persistence.commands.AbstractAccountCommand;
import com.sap.core.tunnelcommands.framework.executor.CommandTunnelRequestExecutor;
import com.sap.core.tunnelcommands.framework.executor.DefaultResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpPostStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseContext;
import com.sap.core.tunnelcommands.framework.executor.HttpUriRequestStrategy;
import com.sap.core.tunnelcommands.framework.executor.ICommandTunnelCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;

@Parameters(commandDescription="BETA: Set or clear trust store for a destination")
public class EditHanaXsDestination
extends AbstractAccountCommand {
    static final String EDIT_HANA_XS_DESTINATION_COMMAND_NAME = "edit-hanaxs-destination";
    @Parameter(names={"--package"}, description="HANA XS development package. Starts with a letter and contains 'a' - 'z' and '0' - '9'")
    private String id;
    @Parameter(names={"--destination"}, description="HANA XS destination. The relative path to the destination within the package. Example: --destination subpackage/my_destination")
    private String destination;
    @Parameter(names={"--truststore"}, description="Name of trust store. Possible values: default.")
    private String trustStore = "default";

    @Override
    public void init() throws CommandException {
        this.checkArgAccount();
        this.checkArgSchemaId();
        this.checkArgDestination();
        this.checkArgTrustStore();
        super.init();
    }

    @Override
    public void cleanup() throws CommandException {
    }

    private void checkArgSchemaId() {
        CheckHelper.checkArgSpecified((String)"--package", (String)"--package", (String)this.id);
    }

    protected void checkArgDestination() {
        CheckHelper.checkArgSpecified((String)"--destination", (String)"--destination", (String)this.destination);
    }

    protected void checkArgTrustStore() {
        CheckHelper.checkArgSpecified((String)"--truststore", (String)"--truststore", (String)this.trustStore);
    }

    public String getGroup() {
        return "hanaxs-development";
    }

    public void run() throws CommandException {
        HttpPostStrategy restCallStrategy = new HttpPostStrategy(this.getCommandParamsAsJson());
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor((HttpUriRequestStrategy)restCallStrategy, (HttpResponseConsumingStrategy)new SetTrustStoreConsumer(), (ICommandTunnelCommand)this, "httpdestination");
        helper.executeRequest();
    }

    private JsonObject getCommandParamsAsJson() {
        JsonObject props = new JsonObject();
        props.addProperty("schemaId", this.id);
        props.addProperty("httpDestination", this.destination);
        props.addProperty("trustStore", this.trustStore);
        return props;
    }

    public String getName() {
        return EDIT_HANA_XS_DESTINATION_COMMAND_NAME;
    }

    class SetTrustStoreConsumer
    extends DefaultResponseConsumingStrategy {
        public void consume(HttpResponseContext context) throws CommandException {
            int statusCode = context.getResponse().getStatusLine().getStatusCode();
            if (statusCode == 200) {
                System.out.println("HANA XS destination edited successfully");
            } else if (statusCode == 400) {
                this.throwCommandExceptionWithContentInfoAndLog(null, context);
            } else {
                super.consume(context);
            }
        }
    }
}

