/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.hanaxs;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.sap.core.persistence.commands.hanaxs.ManageHanaXsIdPCertificates;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public abstract class InsertHanaXsIdPCertificates
extends ManageHanaXsIdPCertificates {
    private static final Logger LOGGER = Logger.getLogger(InsertHanaXsIdPCertificates.class);
    @Parameter(names={"-l", "--localpath"}, description="Path to a X.509 certificate or a directory containing certificates on a local file system. If the local path is a directory all files in it shall be uploaded. Restart of the HANA instances is required to activate the certificates. ")
    protected String localFilePath;
    private List<File> certificatesFiles = new ArrayList<File>();

    public String getLocalFilePath() {
        return this.localFilePath;
    }

    protected List<File> getCertificatesFiles() {
        return this.certificatesFiles;
    }

    protected void checkArgLocalFilePath() {
        CheckHelper.checkArgSpecified((String)"-l", (String)"--localpath", (String)this.localFilePath);
        this.checkFileExists(this.localFilePath);
        this.certificatesFiles = this.getValidCertificates(this.localFilePath);
    }

    protected boolean isLocalFilePathDirectory() {
        return new File(this.localFilePath).isDirectory();
    }

    protected String getLocalFilePathAbsolutePath() {
        return new File(this.localFilePath).getAbsolutePath();
    }

    private void checkFileExists(String pathname) throws CommandException {
        File file = new File(pathname);
        if (!file.exists()) {
            throw new ParameterException("(!) ERROR: Invalid value in parameter --localpath. '" + file.getAbsolutePath() + "' was not found.");
        }
    }

    private List<File> getValidCertificates(String pathname) throws CommandException {
        ArrayList<File> result = new ArrayList<File>();
        File file = new File(pathname);
        if (file.isFile()) {
            if (this.checkFileContainsValidCertificates(file)) {
                result.add(file);
            } else {
                throw new ParameterException("(!) ERROR: Invalid value in parameter --localpath. '" + file.getAbsolutePath() + "' is not a valid certificate.");
            }
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null || files.length == 0) {
                throw new ParameterException("(!) ERROR: Invalid value in parameter --localpath. '" + file.getAbsolutePath() + "' directory does not contain valid certificates.");
            }
            for (File directoryFile : files) {
                if (!directoryFile.isFile() || !this.checkFileContainsValidCertificates(directoryFile)) continue;
                result.add(directoryFile);
            }
            if (result.size() == 0) {
                throw new ParameterException("(!) ERROR: Invalid value in parameter --localpath. '" + file.getAbsolutePath() + "' directory does not contain valid certificates.");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkFileContainsValidCertificates(File file) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            this.getX509Certificates(inputStream);
        }
        catch (Exception e) {
            boolean bl;
            try {
                LOGGER.error((Object)("Problem while parsing certificate from local file:" + file.getAbsolutePath()), (Throwable)e);
                bl = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            return bl;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return true;
    }
}

