/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.hanaxs;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.persistence.commands.entities.IdPCertificatesListResponseEntity;
import com.sap.core.persistence.commands.hanaxs.ManageHanaXsIdPCertificates;
import com.sap.core.tunnelcommands.framework.executor.CommandTunnelRequestExecutor;
import com.sap.core.tunnelcommands.framework.executor.HttpClientProvider;
import com.sap.core.tunnelcommands.framework.executor.HttpGetStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseContext;
import com.sap.core.tunnelcommands.framework.executor.HttpUriRequestStrategy;
import com.sap.core.tunnelcommands.framework.executor.ICommandTunnelCommand;
import com.sap.core.tunnelcommands.framework.executor.JsonConsumingStrategy;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.io.ByteArrayInputStream;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.codec.binary.Base64;

@Parameters(commandDescription="List current certificates.")
public class ListHanaXsIdPCertificates
extends ManageHanaXsIdPCertificates {
    private static final String HANA_XS_GET_IDPS_CERTIFICATES_COMMAND_NAME = "list-hanaxs-certificates";
    private static final String NEW_LINE = System.getProperty("line.separator");
    @Parameter(names={"-cn-string", "--contained-string"}, description="A part of the certificate CN. If more than one certificates contain this string all shall be listed.")
    private String containedString;

    public String getName() {
        return HANA_XS_GET_IDPS_CERTIFICATES_COMMAND_NAME;
    }

    public void run() throws CommandException {
        HttpGetStrategy restCallStrategy = new HttpGetStrategy();
        GetIdPCertificatesConsumer respConsumer = new GetIdPCertificatesConsumer();
        String psaApiPath = "hanaidpcertificate";
        if (!this.isEmpty(this.containedString)) {
            String encodedContainedString = HttpClientProvider.encodeURLString((String)this.containedString);
            encodedContainedString = encodedContainedString.replace("+", "%20");
            psaApiPath = psaApiPath + "/" + encodedContainedString;
        }
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor((HttpUriRequestStrategy)restCallStrategy, (HttpResponseConsumingStrategy)respConsumer, (ICommandTunnelCommand)this, psaApiPath);
        helper.executeRequest(75000);
    }

    private boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    private class GetIdPCertificatesConsumer
    extends JsonConsumingStrategy<IdPCertificatesListResponseEntity> {
        private final SimpleDateFormat dateFormatter;
        private static final String INDENTATION = "          ";
        private final int MAX_LINE_LENGTH;
        private static final String SUBJECT_LABEL = "Subject : ";
        private static final String ISSUER_LABEL = "Issuer  : ";
        private static final String VALIDITY_LABEL = "Validity: ";
        private static final String SEPARATOR = "---------------------------------------------------------------------";
        private Map<String, String> oidMap;

        private GetIdPCertificatesConsumer() {
            super(IdPCertificatesListResponseEntity.class);
            this.dateFormatter = new SimpleDateFormat("dd MMM yyyy HH:mm:ss z");
            this.MAX_LINE_LENGTH = 80 - INDENTATION.length();
            this.oidMap = new HashMap<String, String>();
            this.oidMap.put("1.2.840.113549.1.9.1", "EMAIL");
            this.oidMap.put("2.5.4.8", "SP");
        }

        public void consume(HttpResponseContext context) throws CommandException {
            if (context.getStatusCode() == 200) {
                this.printResult((IdPCertificatesListResponseEntity)this.getJsonObject(context));
            } else {
                super.consume(context);
            }
        }

        private void printResult(IdPCertificatesListResponseEntity certificatesListResp) {
            if (certificatesListResp.getCertificates() == null || certificatesListResp.getCertificates().isEmpty()) {
                if (ListHanaXsIdPCertificates.this.isEmpty(ListHanaXsIdPCertificates.this.containedString)) {
                    System.out.println("No certificates have been uploaded.");
                } else {
                    System.out.println("No certificates were found that contain '" + ListHanaXsIdPCertificates.this.containedString + "' in the CN.");
                }
                return;
            }
            try {
                System.out.println("HANA XS certificates: " + certificatesListResp.getCertificates().size());
                System.out.println(SEPARATOR);
                for (String certificate : certificatesListResp.getCertificates()) {
                    Collection<X509Certificate> x509Certificates = ListHanaXsIdPCertificates.this.getX509Certificates(new ByteArrayInputStream(Base64.decodeBase64((String)certificate)));
                    for (X509Certificate x509Certificate : x509Certificates) {
                        X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
                        x509Certificate.getSubjectX500Principal();
                        String string = x500Principal.getName("RFC1779", this.oidMap);
                        X500Principal x500Principal2 = x509Certificate.getIssuerX500Principal();
                        x509Certificate.getIssuerX500Principal();
                        this.printCertificateInfo(string, x500Principal2.getName("RFC1779", this.oidMap), this.formatDate(x509Certificate.getNotBefore()), this.formatDate(x509Certificate.getNotAfter()));
                    }
                }
            }
            catch (Exception e) {
                throw new CommandException("Received result cannot be processed: " + e.getMessage(), 168);
            }
        }

        private void printCertificateInfo(String subject, String issuer, String fromDate, String toDate) {
            System.out.print(SUBJECT_LABEL);
            System.out.print(this.getOutputSeparatedWithNewLines(subject));
            System.out.print(ISSUER_LABEL);
            System.out.print(this.getOutputSeparatedWithNewLines(issuer));
            System.out.print(VALIDITY_LABEL);
            System.out.println("from " + fromDate);
            System.out.print(INDENTATION);
            System.out.println("to   " + toDate);
            System.out.println(SEPARATOR);
        }

        private String formatDate(Date date) {
            return this.dateFormatter.format(date);
        }

        private String getOutputSeparatedWithNewLines(String str) {
            int length = str.length();
            int chunks = str.length() / this.MAX_LINE_LENGTH;
            if (chunks == 0 || length == this.MAX_LINE_LENGTH) {
                return str + NEW_LINE;
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i <= chunks; ++i) {
                int endIndex;
                int beginIndex = i * this.MAX_LINE_LENGTH;
                int n = endIndex = (i + 1) * this.MAX_LINE_LENGTH < length ? (i + 1) * this.MAX_LINE_LENGTH : length;
                if (i > 0) {
                    builder.append(INDENTATION);
                }
                builder.append(str.substring(beginIndex, endIndex));
                builder.append(NEW_LINE);
            }
            return builder.toString();
        }
    }
}

