/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.hanaxs;

import com.beust.jcommander.Parameters;
import com.sap.core.persistence.commands.hanaxs.InsertHanaXsIdPCertificates;
import com.sap.core.persistence.commands.hanaxs.ManageIdPCertificateResponseConsumer;
import com.sap.core.tunnelcommands.framework.executor.CommandTunnelRequestExecutor;
import com.sap.core.tunnelcommands.framework.executor.HttpPutMultiPartStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpUriRequestStrategy;
import com.sap.core.tunnelcommands.framework.executor.ICommandTunnelCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.io.File;
import java.util.List;

@Parameters(commandDescription="Uploads and applies X.509 certificates to productive HANA instances.")
public class UploadHanaXsIdPCertificate
extends InsertHanaXsIdPCertificates {
    private static final String HANA_XS_UPLOAD_IDP_CERTIFICATE_COMMAND_NAME = "upload-hanaxs-certificates";

    public String getName() {
        return HANA_XS_UPLOAD_IDP_CERTIFICATE_COMMAND_NAME;
    }

    @Override
    public void init() throws CommandException {
        super.init();
        this.checkArgLocalFilePath();
    }

    public void run() throws CommandException {
        HttpUriRequestStrategy restCallStrategy = this.getRestCallStrategy();
        ManageIdPCertificateResponseConsumer respConsumer = new ManageIdPCertificateResponseConsumer();
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor(restCallStrategy, (HttpResponseConsumingStrategy)respConsumer, (ICommandTunnelCommand)this, "hanaidpcertificate");
        helper.executeRequest(75000);
    }

    private HttpUriRequestStrategy getRestCallStrategy() {
        List<File> certificatesFiles = this.getCertificatesFiles();
        System.out.println("The following certificates will be uploaded: " + certificatesFiles);
        return new HttpPutMultiPartStrategy(certificatesFiles);
    }
}

