/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.jmx.client;

import com.sap.core.persistence.commands.jmx.client.DaemonProcessController;
import com.sap.core.persistence.commands.jmx.server.JmxDaemon;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class JmxDaemonClient<T> {
    private static final int MAX_DAEMON_STARTUP_ATTEMPTS = 2;
    private static Logger logger = Logger.getLogger(JmxDaemonClient.class);
    private final int jmxPort;
    private final Class<T> beanInterface;
    private final Class<? extends T> beanImplementationClass;
    private JmxDaemonCommandLine commandLineProvider;
    private JMXConnector jmxConnection;

    public JmxDaemonClient(Class<T> beanInterface, Class<? extends T> beanImplementationClass, int jmxPort) {
        this(beanInterface, beanImplementationClass, jmxPort, new JmxDaemonCommandLine());
    }

    public JmxDaemonClient(Class<T> beanInterface, Class<? extends T> beanImplementationClass, int jmxPort, JmxDaemonCommandLine commandLineProvider) {
        this.jmxPort = jmxPort;
        this.beanInterface = beanInterface;
        this.beanImplementationClass = beanImplementationClass;
        this.commandLineProvider = commandLineProvider;
        if (jmxPort <= 0) {
            throw new IllegalArgumentException("JMX port must be greater than 0 (was '" + jmxPort + "')");
        }
    }

    public T connectToDaemonIfRunning() {
        try {
            this.logAndPrintToSysout((Priority)Level.INFO, "Trying to connect to background process...");
            this.jmxConnection = JMXConnectorFactory.connect(JmxDaemonClient.getDaemonJmxServiceUrl(this.jmxPort), null);
            return this.connectToBean(this.jmxConnection);
        }
        catch (IOException connectBeforeStartException) {
            this.logAndPrintToSysout((Priority)Level.INFO, "No background process is running");
            return null;
        }
    }

    private T connectToBean(JMXConnector jmxConnector) throws IOException {
        T beanProxy = this.getBeanProxy(jmxConnector);
        this.logAndPrintToSysout((Priority)Level.INFO, "Connected to background process");
        return beanProxy;
    }

    public T connectToDaemon() throws CommandException {
        IOException failedAttempt = null;
        for (int attemptIx = 0; attemptIx < 2; ++attemptIx) {
            if (failedAttempt != null) {
                this.logAndPrintToSysout((Priority)Level.INFO, "Could not connect to background process. Waiting two seconds before retrying...");
                this.sleep(2000L);
            }
            try {
                T beanProxy = this.connectToDaemonWithAutomaticStart();
                logger.info((Object)("Connection to background process established " + (attemptIx == 0 ? "" : " after " + (attemptIx + 1) + " attempts")));
                return beanProxy;
            }
            catch (IOException e) {
                failedAttempt = e;
                continue;
            }
        }
        String message = "Failed to connect to background process after 2 retries: " + failedAttempt;
        logger.error((Object)message, (Throwable)failedAttempt);
        throw new CommandException(message, (Throwable)failedAttempt);
    }

    private void sleep(long timeInMilis) {
        try {
            Thread.sleep(timeInMilis);
        }
        catch (InterruptedException e) {
            logger.debug((Object)("InterruptedException while waiting: " + e.getMessage()), (Throwable)e);
        }
    }

    private T connectToDaemonWithAutomaticStart() throws IOException {
        T beanProxy = this.connectToDaemonIfRunning();
        if (beanProxy != null) {
            return beanProxy;
        }
        return this.startDaemonProcessAndConnect();
    }

    private T startDaemonProcessAndConnect() throws IOException {
        this.logAndPrintToSysout((Priority)Level.INFO, "Creating new background process...");
        DaemonProcessController controller = this.startJmxDaemonProcess();
        try {
            this.jmxConnection = JMXConnectorFactory.connect(JmxDaemonClient.getDaemonJmxServiceUrl(this.jmxPort), null);
        }
        catch (IOException e) {
            logger.error((Object)"Could not connect to background process", (Throwable)e);
            throw this.closeProcessAndCreateException(controller);
        }
        return this.connectToBean(this.jmxConnection);
    }

    private IOException closeProcessAndCreateException(DaemonProcessController controller) throws IOException {
        String err;
        Integer exitValue = controller.getExitValue();
        try {
            err = controller.getErrorStreamSnippet(4096);
        }
        catch (Exception e) {
            throw new IOException("Cannot get ErrorStreamSnippet", e);
        }
        controller.destroyProcess();
        return new IOException("Failed to connect to background process, exit value=" + exitValue + ", error stream:{\n" + err + "\n}\n");
    }

    private static JMXServiceURL getDaemonJmxServiceUrl(int jmxPort) {
        try {
            return new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:" + jmxPort + "/jmxrmi");
        }
        catch (MalformedURLException e) {
            throw new CommandException("Cannot create JmxServiceUrl", (Throwable)e);
        }
    }

    private DaemonProcessController startJmxDaemonProcess() throws IOException {
        List<String> cmd = this.getCommandLine();
        DaemonProcessController controller = new DaemonProcessController(cmd);
        try {
            controller.start();
        }
        catch (IOException e) {
            throw new IOException("Cannot start background process", e);
        }
        controller.waitForOutput("JmxDaemon.main():ready", 20000);
        return controller;
    }

    private T getBeanProxy(JMXConnector jmxConnector) throws IOException {
        MBeanServerConnection mbserver = jmxConnector.getMBeanServerConnection();
        ObjectName tunnelManagerObjectName = JmxDaemon.getHostedJmxObjectName();
        return JMX.newMBeanProxy(mbserver, tunnelManagerObjectName, this.beanInterface);
    }

    private List<String> getCommandLine() {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add("java");
        commandLine.addAll(this.commandLineProvider.getJvmParameters(this.jmxPort));
        commandLine.addAll(this.commandLineProvider.getApplicationParameters(this.jmxPort, this.beanImplementationClass));
        return commandLine;
    }

    private void logAndPrintToSysout(Priority priority, String message) {
        String logLevelString = priority.equals((Object)Level.INFO) ? "" : priority.toString() + ": ";
        System.out.println(logLevelString + message);
        logger.log(priority, (Object)message);
    }

    static void copySystemProperty(List<String> commandLine, String propertyName) {
        String propertyValue = System.getProperty(propertyName);
        if (propertyValue != null && propertyValue.length() > 0) {
            commandLine.add("-D" + propertyName + "=" + propertyValue);
        }
    }

    public void close() {
        if (this.jmxConnection != null) {
            try {
                this.jmxConnection.close();
            }
            catch (IOException e) {
                logger.warn((Object)"Exception while closing connection to background process", (Throwable)e);
            }
            this.jmxConnection = null;
        }
    }

    public static class JmxDaemonCommandLine {
        public List<String> getJvmParameters(int jmxPort) {
            ArrayList<String> result = new ArrayList<String>();
            result.add("-Dneo.process.name=tunnel_background_" + jmxPort);
            result.add("-Dneo.logging.location=" + System.getProperty("neo.logging.location"));
            JmxDaemonClient.copySystemProperty(result, "http.proxyHost");
            JmxDaemonClient.copySystemProperty(result, "http.proxyPort");
            JmxDaemonClient.copySystemProperty(result, "http.proxyUser");
            JmxDaemonClient.copySystemProperty(result, "http.proxyPassword");
            JmxDaemonClient.copySystemProperty(result, "http.nonProxyHosts");
            JmxDaemonClient.copySystemProperty(result, "https.proxyHost");
            JmxDaemonClient.copySystemProperty(result, "https.proxyPort");
            JmxDaemonClient.copySystemProperty(result, "https.proxyUser");
            JmxDaemonClient.copySystemProperty(result, "https.proxyPassword");
            JmxDaemonClient.copySystemProperty(result, "https.nonProxyHosts");
            result.add("-classpath");
            result.add(System.getProperty("java.class.path"));
            return result;
        }

        public List<String> getApplicationParameters(int jmxPort, Class<?> beanImplementationClass) {
            ArrayList<String> result = new ArrayList<String>();
            result.add(JmxDaemon.class.getName());
            result.add(Integer.toString(jmxPort));
            result.add(beanImplementationClass.getName());
            return result;
        }
    }
}

