/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.jmx.server;

import com.sap.core.persistence.commands.jmx.server.DaemonActivityListener;
import com.sap.core.persistence.commands.jmx.server.DaemonActivityNotifyingBean;
import com.sap.core.persistence.commands.jmx.server.JmxDaemonShutdownManager;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.rmi.registry.LocateRegistry;
import java.util.Arrays;
import java.util.HashMap;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.log4j.Logger;

public class JmxDaemon
implements DaemonActivityListener {
    public static final String JMX_DAEMON_READY = "JmxDaemon.main():ready";
    private static final Logger logger = Logger.getLogger(JmxDaemon.class);
    private static JmxDaemon instance;
    private final JMXConnectorServer connectorServer;
    private final MBeanServer beanServer;
    private final JmxDaemonShutdownManager shutdownHandler;

    public JmxDaemon(JMXConnectorServer connectorServer, MBeanServer beanServer) {
        this.connectorServer = connectorServer;
        this.beanServer = beanServer;
        this.shutdownHandler = new JmxDaemonShutdownManager(connectorServer, logger);
    }

    public static void main(String[] args) {
        try {
            logger.info((Object)"Background process started");
            int jmxPort = Integer.parseInt(args[0]);
            String beanImplClassName = args[1];
            Class<?> beanImplClass = Class.forName(beanImplClassName);
            JmxDaemon.initializeJmxAndLogging(jmxPort, beanImplClass.newInstance());
        }
        catch (Exception e) {
            logger.error((Object)"Unexpected exception caught; stopping background process", (Throwable)e);
            System.exit(1);
        }
    }

    private static void initializeJmxAndLogging(int jmxPort, Object beanImpl) throws IOException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        instance = JmxDaemon.createMBeanServerWithOwnConnectorServer(jmxPort);
        if (beanImpl instanceof DaemonActivityNotifyingBean) {
            ((DaemonActivityNotifyingBean)beanImpl).setListener(instance);
        }
        JmxDaemon.instance.beanServer.registerMBean(beanImpl, JmxDaemon.getHostedJmxObjectName());
        JmxDaemon.instance.connectorServer.start();
        System.out.println(JMX_DAEMON_READY);
        logger.info((Object)("Finished JMX setup on port '" + jmxPort + "'."));
        JmxDaemon.tieSystemOutAndErrToLog();
    }

    private static JmxDaemon createMBeanServerWithOwnConnectorServer(int jmxPort) throws IOException {
        LocateRegistry.createRegistry(jmxPort);
        MBeanServer beanServer = MBeanServerFactory.createMBeanServer();
        HashMap env = new HashMap();
        JMXServiceURL jmxUrl = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:" + jmxPort + "/jmxrmi");
        JMXConnectorServer connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(jmxUrl, env, beanServer);
        return new JmxDaemon(connectorServer, beanServer);
    }

    private static void tieSystemOutAndErrToLog() {
        System.setOut(JmxDaemon.createLoggingProxy(System.out));
        System.setErr(JmxDaemon.createLoggingProxy(System.err));
    }

    private static PrintStream createLoggingProxy(final PrintStream originalPrintStream) {
        try {
            return new PrintStream(originalPrintStream, false, "UTF-8"){

                @Override
                public void print(String string) {
                    originalPrintStream.print(string);
                    logger.info((Object)string);
                }
            };
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"Cannot create PrintStream with encoding 'UTF-8'.", (Throwable)e);
            return null;
        }
    }

    public static ObjectName getHostedJmxObjectName() {
        try {
            return new ObjectName("com.sap.core.persistence.commands.background:type=manager");
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void notifyOfBackgroundActivity(boolean backgroundActivity) {
        if (backgroundActivity) {
            this.shutdownHandler.cancelShutdown();
        } else {
            Object[] connectionIds = this.connectorServer.getConnectionIds();
            logger.info((Object)("Manager is idle. Active JMX connections: " + Arrays.toString(connectionIds)));
            this.shutdownHandler.triggerShutdown();
        }
    }
}

