/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.jmx.server;

import java.io.IOException;
import javax.management.remote.JMXConnectorServer;
import org.apache.log4j.Logger;

class JmxDaemonShutdownManager {
    private final JMXConnectorServer connectorServer;
    private final Logger logger;
    private Thread activeShutdownThread;

    public JmxDaemonShutdownManager(JMXConnectorServer connectorServer, Logger logger) {
        this.connectorServer = connectorServer;
        this.logger = logger;
    }

    synchronized void cancelShutdown() {
        this.activeShutdownThread = null;
    }

    synchronized Thread getActiveShutdownThread() {
        return this.activeShutdownThread;
    }

    synchronized void triggerShutdown() {
        if (this.activeShutdownThread == null) {
            this.activeShutdownThread = new ShutdownThread();
            this.activeShutdownThread.setDaemon(true);
            this.activeShutdownThread.start();
        }
    }

    private class ShutdownThread
    extends Thread {
        private ShutdownThread() {
        }

        @Override
        public void run() {
            try {
                while (JmxDaemonShutdownManager.this.getActiveShutdownThread() == this) {
                    String[] connectionIds = JmxDaemonShutdownManager.this.connectorServer.getConnectionIds();
                    if (connectionIds.length == 0) {
                        JmxDaemonShutdownManager.this.logger.info((Object)"Shutting down JMX connector server");
                        JmxDaemonShutdownManager.this.connectorServer.stop();
                        Thread.sleep(2000L);
                        JmxDaemonShutdownManager.this.logger.info((Object)"Terminating background process");
                        System.exit(0);
                        return;
                    }
                    Thread.sleep(100L);
                }
            }
            catch (IOException e) {
                JmxDaemonShutdownManager.this.logger.error((Object)"Error while shutting down JMX connector server", (Throwable)e);
            }
            catch (InterruptedException e) {
                JmxDaemonShutdownManager.this.logger.error((Object)"Error while shutting down JMX connector server", (Throwable)e);
            }
        }
    }
}

