/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.schema.api;

import com.sap.core.persistence.commands.entities.DbsInfoEntity;
import com.sap.core.persistence.commands.schema.ListDbsConsumer;
import com.sap.core.persistence.commands.schema.api.ListSchemaAndDbmsHandler;
import com.sap.core.persistence.commands.schema.api.entities.DbInfo;
import com.sap.core.persistence.commands.schema.api.entities.DbmsInfo;
import com.sap.core.persistence.commands.schema.api.entities.SchemaInfo;
import com.sap.core.persistence.commands.schema.api.entities.TenantDbInfo;
import com.sap.core.tunnelcommands.framework.executor.BackendCall;
import com.sap.core.tunnelcommands.framework.executor.CommandTunnelRequestExecutor;
import com.sap.core.tunnelcommands.framework.executor.HttpGetStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpUriRequestStrategy;
import com.sap.core.tunnelcommands.framework.executor.ICommandTunnelCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ListAllTunnelEndpointsHandler
extends ListSchemaAndDbmsHandler {
    public static final int VALUE_NO_TIMEOUT = 0;

    public List<DbInfo> listAllTunnelEndpoints() {
        ArrayList<DbInfo> dbInfos = new ArrayList<DbInfo>();
        List<SchemaInfo> sharedSchemas = this.listSharedSchemas();
        ArrayList<DbmsInfo> dedicatedDbs = this.listDedicatedDbs();
        ArrayList<TenantDbInfo> tenants = this.listTenantDatabases();
        dbInfos.addAll(sharedSchemas);
        dbInfos.addAll(dedicatedDbs);
        dbInfos.addAll(tenants);
        return dbInfos;
    }

    public ArrayList<TenantDbInfo> listTenantDatabases() {
        List<DbsInfoEntity> dbs = this.listDatabases();
        ArrayList<TenantDbInfo> tenantDbs = new ArrayList<TenantDbInfo>();
        for (DbsInfoEntity db : dbs) {
            TenantDbInfo tenantDbInfo = new TenantDbInfo(db.getDatabaseId(), db.getDbType(), db.getDbVersion(), db.getRootURL());
            tenantDbs.add(tenantDbInfo);
        }
        return tenantDbs;
    }

    private List<DbsInfoEntity> listDatabases() {
        ListDbsConsumer httpUriRequestStrategy = new ListDbsConsumer();
        BackendCall backendCall = new BackendCall("list-dbs", this.host, this.account, this.user, this.password, this.serviceName, "v1");
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor((HttpUriRequestStrategy)new HttpGetStrategy(), (HttpResponseConsumingStrategy)httpUriRequestStrategy, (ICommandTunnelCommand)backendCall, "hana/databases");
        helper.executeRequest();
        DbsInfoEntity[] dbs = httpUriRequestStrategy.getJsonObject();
        return Arrays.asList(dbs);
    }
}

