/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.schema.api;

import com.sap.core.persistence.commands.entities.DbmsInfoEntity;
import com.sap.core.persistence.commands.entities.Schema;
import com.sap.core.persistence.commands.schema.ListDbmsConsumer;
import com.sap.core.persistence.commands.schema.ListPackageConsumer;
import com.sap.core.persistence.commands.schema.ListSchemaConsumer;
import com.sap.core.persistence.commands.schema.api.entities.DbInfo;
import com.sap.core.persistence.commands.schema.api.entities.DbmsInfo;
import com.sap.core.persistence.commands.schema.api.entities.SchemaInfo;
import com.sap.core.tunnelcommands.framework.executor.BackendCall;
import com.sap.core.tunnelcommands.framework.executor.CommandTunnelRequestExecutor;
import com.sap.core.tunnelcommands.framework.executor.HttpGetStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpUriRequestStrategy;
import com.sap.core.tunnelcommands.framework.executor.ICommandTunnelCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ListSchemaAndDbmsHandler {
    public static final int VALUE_NO_TIMEOUT = 0;
    private static final String LIST_PACKAGES_REST_CALL = "list-packages";
    protected String account;
    protected String host;
    protected String user;
    protected String password;
    protected String serviceName;

    public void setAccount(String account) {
        this.account = account;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public List<DbInfo> listSharedSchemasAndDedicatedDbms() {
        ArrayList<DbInfo> dbInfos = new ArrayList<DbInfo>();
        List<SchemaInfo> sharedSchemas = this.listSharedSchemas();
        ArrayList<DbmsInfo> dedicatedDbs = this.listDedicatedDbs();
        dbInfos.addAll(sharedSchemas);
        dbInfos.addAll(dedicatedDbs);
        return dbInfos;
    }

    public List<SchemaInfo> listSharedSchemas() {
        List<Schema> schemas = this.listSchemas();
        ArrayList<SchemaInfo> sharedSchemas = new ArrayList<SchemaInfo>();
        SchemaInfo currSharedSchema = null;
        for (Schema schema : schemas) {
            if (!this.isSharedSchema(schema)) continue;
            currSharedSchema = new SchemaInfo(schema.getSchemaId(), schema.getDbType(), schema.getDbVersion(), schema.getDisplayDBSystemName());
            currSharedSchema.setListSchemaHandler(this);
            sharedSchemas.add(currSharedSchema);
        }
        return sharedSchemas;
    }

    public ArrayList<DbmsInfo> listDedicatedDbs() {
        List<DbmsInfoEntity> dbms = this.listDbms();
        ArrayList<DbmsInfo> dedicatedDbs = new ArrayList<DbmsInfo>();
        DbmsInfo currDedicatedDbmsInfo = null;
        String currRootUrl = null;
        for (DbmsInfoEntity db : dbms) {
            boolean dedicated = this.isDbDedicated(db);
            if (!dedicated) continue;
            String[] rootUrls = db.getRootURLs();
            if (rootUrls != null && rootUrls.length > 0) {
                currRootUrl = rootUrls[0];
            }
            currDedicatedDbmsInfo = new DbmsInfo(db.getDbAliasName(), db.getDbType(), db.getDbVersion(), currRootUrl, db.getDbServerNature());
            dedicatedDbs.add(currDedicatedDbmsInfo);
        }
        return dedicatedDbs;
    }

    private List<Schema> listSchemas() {
        ListSchemaConsumer httpUriRequestStrategy = new ListSchemaConsumer();
        BackendCall backendCall = new BackendCall("list-schemas", this.host, this.account, this.user, this.password, this.serviceName, "v1");
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor((HttpUriRequestStrategy)new HttpGetStrategy(), (HttpResponseConsumingStrategy)httpUriRequestStrategy, (ICommandTunnelCommand)backendCall, "schemas/");
        helper.executeRequest();
        Schema[] schemas = httpUriRequestStrategy.getJsonObject().getSchemas();
        return Arrays.asList(schemas);
    }

    private List<DbmsInfoEntity> listDbms() {
        ListDbmsConsumer httpUriRequestStrategy = new ListDbmsConsumer();
        BackendCall backendCall = new BackendCall("list-dbms", this.host, this.account, this.user, this.password, this.serviceName, "v1");
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor((HttpUriRequestStrategy)new HttpGetStrategy(), (HttpResponseConsumingStrategy)httpUriRequestStrategy, (ICommandTunnelCommand)backendCall, "dbms");
        helper.executeRequest();
        DbmsInfoEntity[] dbms = httpUriRequestStrategy.getJsonObject();
        return Arrays.asList(dbms);
    }

    private boolean isSharedSchema(Schema schema) {
        return schema.getDbSystemName().contains("shared");
    }

    private boolean isDbDedicated(DbmsInfoEntity db) {
        String dbServerNature = db.getDbServerNature();
        return "DEDICATED_UNMANAGED".equals(dbServerNature);
    }

    public String getSchemaXsHost(String schemaId) {
        BackendCall backendCall = new BackendCall(LIST_PACKAGES_REST_CALL, this.host, this.account, this.user, this.password, this.serviceName, "v1");
        ListPackageConsumer httpUriRequestStrategy = new ListPackageConsumer();
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor((HttpUriRequestStrategy)new HttpGetStrategy(), (HttpResponseConsumingStrategy)httpUriRequestStrategy, (ICommandTunnelCommand)backendCall, "packages/" + schemaId);
        helper.executeRequest();
        String[] rootUrls = httpUriRequestStrategy.getJsonObject().getRootURLs();
        if (rootUrls != null && rootUrls.length > 0) {
            return rootUrls[0];
        }
        return null;
    }
}

