/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.tunnel;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.sap.core.persistence.commands.tunnel.background.BackgroundTunnelClient;
import com.sap.core.persistence.commands.tunnel.background.BackgroundTunnelSessionCloseResult;
import com.sap.jpaas.infrastructure.console.command.ConsoleCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.io.File;

@Parameters(commandDescription="Closes one or all database tunnel sessions that have been opened in the background process")
public class CloseDbTunnelCommand
extends ConsoleCommand<Object> {
    public static final String CLOSE_DB_TUNNEL_COMMAND_NAME = "close-db-tunnel";
    @Parameter(names={"--session-id"}, description="Tunnel session to close. Cannot be used together with parameter '--all'")
    private String sessionId;
    @Parameter(names={"--jmx-port"}, description="JMX port for connecting to background process (default: 1919)", required=false, hidden=true)
    private int jmxPort;
    @Parameter(names={"--all"}, description="Close all tunnels in background process")
    private boolean closeAllDbTunnels;

    public void init() throws CommandException {
        this.checkParameters();
    }

    public String getName() {
        return CLOSE_DB_TUNNEL_COMMAND_NAME;
    }

    public String getGroup() {
        return "database tunnel";
    }

    public void run() throws CommandException {
        this.jmxPort = BackgroundTunnelClient.evaluateJmxPort(this.jmxPort);
        System.out.println();
        BackgroundTunnelClient backgroundTunnelClient = this.createBackgroundTunnelClient();
        BackgroundTunnelSessionCloseResult backgroundTunnelSessionCloseResult = this.closeAllDbTunnels ? backgroundTunnelClient.closeAllDbTunnels(this.jmxPort) : backgroundTunnelClient.closeDbTunnelSession(this.jmxPort, this.sessionId);
        switch (backgroundTunnelSessionCloseResult) {
            case TUNNEL_SESSION_NOT_FOUND: {
                System.out.println("WARNING: The background tunnel session cannot be found. Maybe the background tunnel expired or was terminated." + this.getCheckLogFileMessage());
                break;
            }
            case TUNNEL_CLOSED: {
                System.out.println("The background tunnel has been closed.");
                break;
            }
            case TUNNEL_SESSION_CLOSED: {
                System.out.println("The background tunnel session has been closed.");
                break;
            }
            case TUNNEL_MANAGER_IS_DOWN: {
                System.out.println("No background tunnel manager is running.");
                break;
            }
            case TUNNEL_MANAGER_HAS_SHUT_DOWN: {
                if (this.closeAllDbTunnels) {
                    System.out.println("All tunnels have been closed. The background tunnel manager has shut down.");
                    break;
                }
                System.out.println("No more open tunnels. The background tunnel manager has shut down.");
                break;
            }
            case TUNNEL_CLOSED_ALL: {
                System.out.println("WARNING: All tunnels have been closed, but background tunnel manager has not been shut down." + this.getCheckLogFileMessage());
                break;
            }
            default: {
                throw new CommandException("Unknown BackgroundTunnelSessionCloseResult '" + (Object)((Object)backgroundTunnelSessionCloseResult) + "'. " + "Background tunnel manager has JMX port '" + this.jmxPort + "'. Tunnel session id is '" + this.sessionId + "'.");
            }
        }
        System.out.println();
    }

    private void checkParameters() throws ParameterException {
        boolean isSessionIdSet;
        boolean bl = isSessionIdSet = this.sessionId != null && !this.sessionId.trim().isEmpty();
        if (this.closeAllDbTunnels && isSessionIdSet) {
            throw new ParameterException("You cannot use '--all' together with '--session-id'");
        }
        if (!this.closeAllDbTunnels && !isSessionIdSet) {
            throw new ParameterException("You must either use '--all' or '--session-id'");
        }
    }

    private String getCheckLogFileMessage() {
        String logFilePath = System.getProperty("neo.logging.location") + File.separator + BackgroundTunnelClient.getBackgroundProcessConsoleLogfileName(this.jmxPort);
        return " Check background tunnel manager's log file '" + logFilePath + "' for further information.";
    }

    protected BackgroundTunnelClient createBackgroundTunnelClient() {
        return new BackgroundTunnelClient();
    }

    public void cleanup() throws CommandException {
    }
}

