/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.tunnel;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.google.gson.JsonObject;
import com.sap.core.persistence.commands.AbstractAccountCommand;
import com.sap.core.tunnelcommands.framework.executor.CommandTunnelRequestExecutor;
import com.sap.core.tunnelcommands.framework.executor.DefaultResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpPutStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseContext;
import com.sap.core.tunnelcommands.framework.executor.HttpUriRequestStrategy;
import com.sap.core.tunnelcommands.framework.executor.ICommandTunnelCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;

@Parameters(commandDescription="Generates a token that grants the members of another subaccount access to a database using a database tunnel. Instead of the database ID, the token is used to open the database tunnel.")
public class GrantDbTunnelAccessCommand
extends AbstractAccountCommand {
    @Parameter(names={"-i", "--id"}, description="Database ID")
    private String id;
    @Parameter(names={"--to-account"}, description="The subaccount to be granted database tunnel access based on the access token.")
    private String toAccount;
    private static final String GRANT_DB_TUNNEL_ACCESS_COMMAND_NAME = "grant-db-tunnel-access";

    public String getName() {
        return GRANT_DB_TUNNEL_ACCESS_COMMAND_NAME;
    }

    public String getGroup() {
        return "database tunnel";
    }

    @Override
    public void init() throws CommandException {
        super.init();
        this.checkArgId();
        GrantDbTunnelAccessCommand.checkToAccount(this.toAccount);
        if (this.getAccount().equals(this.toAccount)) {
            String msg = "--account and --to-account cannot refer to the same subaccount.";
            throw new ParameterException(msg);
        }
    }

    private void checkArgId() {
        CheckHelper.checkArgSpecified((String)"-i", (String)"--id", (String)this.id);
    }

    static void checkToAccount(String toAccount) {
        CheckHelper.checkArgSpecified(null, (String)"--to-account", (String)toAccount);
    }

    public void run() throws CommandException {
        HttpPutStrategy restCallStrategy = new HttpPutStrategy(this.getCommandParamsAsJson());
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor((HttpUriRequestStrategy)restCallStrategy, (HttpResponseConsumingStrategy)new CreateAccessTokenConsumer(), (ICommandTunnelCommand)this, "dbtunnelaccesstoken/");
        helper.executeRequest();
    }

    private JsonObject getCommandParamsAsJson() {
        JsonObject props = new JsonObject();
        props.addProperty("toAccount", this.toAccount);
        props.addProperty("databaseId", this.id);
        return props;
    }

    class CreateAccessTokenConsumer
    extends DefaultResponseConsumingStrategy {
        public void consume(HttpResponseContext context) throws CommandException {
            int statusCode = context.getResponse().getStatusLine().getStatusCode();
            if (statusCode == 201) {
                String output = "Access granted. Token for opening database tunnel from subaccount '" + GrantDbTunnelAccessCommand.this.toAccount + "'  to database '" + GrantDbTunnelAccessCommand.this.id + "': " + context.getResponseContentString();
                System.out.println(output);
            } else if (statusCode == 400) {
                this.throwCommandExceptionWithContentInfoAndLog(null, context);
            } else {
                super.consume(context);
            }
        }
    }
}

