/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.tunnel;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.persistence.commands.AbstractAccountCommand;
import com.sap.core.persistence.commands.entities.DbTunnelAccessTokenResponse;
import com.sap.core.tunnelcommands.framework.executor.CommandTunnelRequestExecutor;
import com.sap.core.tunnelcommands.framework.executor.HttpClientProvider;
import com.sap.core.tunnelcommands.framework.executor.HttpGetStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseContext;
import com.sap.core.tunnelcommands.framework.executor.HttpUriRequestStrategy;
import com.sap.core.tunnelcommands.framework.executor.ICommandTunnelCommand;
import com.sap.core.tunnelcommands.framework.executor.JsonConsumingStrategy;
import com.sap.core.tunnelcommands.util.FormattedTable;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.util.List;

@Parameters(commandDescription="Lists all currently active grants for database tunnel access for a specified subaccount.")
public class ListDbTunnelAccessGrantsCommand
extends AbstractAccountCommand {
    static final String TABLE_HEADER = "Currently active database Tunnel Access Grants:";
    static final String ACCESSTOKEN_HEADER_LABEL = "Access Token";
    static final String SCHEMA_ID_HEADER_LABEL = "Database ID";
    static final String GRANTED_TO_HEADER_LABEL = "Granted To";
    static final String LIST_DB_TUNNEL_ACCESS_GRANTS_COMMAND_NAME = "list-db-tunnel-access-grants";
    @Parameter(names={"-i", "--id"}, description="(Optional) Database ID")
    private String id;

    public String getName() {
        return LIST_DB_TUNNEL_ACCESS_GRANTS_COMMAND_NAME;
    }

    public String getGroup() {
        return "database tunnel";
    }

    public void run() throws CommandException {
        String psaApiPath = "dbtunnelaccesstokens/";
        if (this.id != null) {
            psaApiPath = psaApiPath + HttpClientProvider.encodeURLString((String)this.id);
        }
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor((HttpUriRequestStrategy)new HttpGetStrategy(), (HttpResponseConsumingStrategy)new ListAccessTokenConsumer(), (ICommandTunnelCommand)this, psaApiPath);
        helper.executeRequest();
    }

    protected class ListAccessTokenConsumer
    extends JsonConsumingStrategy<DbTunnelAccessTokenResponse> {
        private ListAccessTokenConsumer() {
            super(DbTunnelAccessTokenResponse.class);
        }

        public void consume(HttpResponseContext context) throws CommandException {
            if (context.getStatusCode() == 200) {
                this.printResult(this.getJsonArray(context));
            } else {
                super.consume(context);
            }
        }

        void printResult(List<DbTunnelAccessTokenResponse> responseList) {
            FormattedTable table = new FormattedTable(new String[]{ListDbTunnelAccessGrantsCommand.SCHEMA_ID_HEADER_LABEL, ListDbTunnelAccessGrantsCommand.GRANTED_TO_HEADER_LABEL, ListDbTunnelAccessGrantsCommand.ACCESSTOKEN_HEADER_LABEL});
            for (DbTunnelAccessTokenResponse satr : responseList) {
                table.addRow(new String[]{satr.getDatabaseId(), satr.getToAccount(), satr.getAccessToken()});
            }
            System.out.println(ListDbTunnelAccessGrantsCommand.TABLE_HEADER);
            table.printTo(System.out);
        }
    }
}

