/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.tunnel;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.sap.core.persistence.commands.AbstractAccountCommand;
import com.sap.core.persistence.commands.tunnel.OpenDbTunnelStructuredOutput;
import com.sap.core.persistence.commands.tunnel.api.CommandTunnelHandler;
import com.sap.core.persistence.commands.tunnel.api.IncompatibleServerVersionException;
import com.sap.core.persistence.commands.tunnel.api.TunnelBackendInformation;
import com.sap.core.persistence.commands.tunnel.api.TunnelMessageListener;
import com.sap.core.persistence.commands.tunnel.api.TunnelStateListener;
import com.sap.core.persistence.commands.tunnel.background.BackgroundTunnelClient;
import com.sap.core.persistence.commands.tunnel.background.TunnelParameters;
import com.sap.core.persistence.commands.tunnel.background.TunnelSessionProperties;
import com.sap.core.persistence.commands.tunnel.connection.DBSpecificHelper;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;

@Parameters(commandDescription="Opens a database tunnel to the database system for the specified schema/database.")
public class OpenDbTunnelCommand
extends AbstractAccountCommand {
    static final int DEFAULT_TIMEOUT_SHELL_PROCESS_HOURS = 24;
    static final int DEFAULT_TIMEOUT_BACKGROUND_PROCESS_HOURS = 1;
    public static final String OPEN_DB_TUNNEL_COMMAND_NAME = "open-db-tunnel";
    @Parameter(names={"-i", "--id"}, description="Database or schema ID. If the database is owned by another subaccount, its ID must be supplied as 'accountName:databaseID'.")
    private String schemaId = null;
    @Parameter(names={"--access-token"}, description="Token for opening a tunnel to a database in another subaccount. Contact the subaccount owner to request a token.")
    private String accessToken = null;
    @Parameter(names={"--timeout"}, description="Timeout in hours (0 to deactivate, default: 24).\n                      For --background: Can't deactivate timeout, default: 1.", required=false, hidden=true)
    private Integer timeoutHours;
    @Parameter(names={"--background"}, description="Open (or reuse) tunnel in a background process", required=false)
    private boolean background;
    @Parameter(names={"--jmx-port"}, description="JMX port for connecting to background process (default: 1919)", required=false, hidden=true)
    private int jmxPort;
    private boolean isShutdown;

    @Override
    public void init() throws CommandException {
        this.checkParameters();
        super.init();
    }

    private void checkParameters() {
        this.checkBothIdAndAccessTokenParameters();
        this.checkBothBackgroundAndAccessTokenParameters();
        this.timeoutHours = OpenDbTunnelCommand.getTimeoutParameter(this.background, this.timeoutHours);
    }

    private void checkBothIdAndAccessTokenParameters() {
        if (this.schemaId != null && this.accessToken != null) {
            throw new ParameterException("Parameters '--id' and '--access-token' are mutually exclusive and must not be specified together");
        }
        if (this.schemaId == null && this.accessToken == null) {
            throw new ParameterException("One of the parameters '--id' or '--access-token' must be specified");
        }
    }

    private void checkBothBackgroundAndAccessTokenParameters() {
        if (this.background && this.accessToken != null) {
            throw new ParameterException("Parameters '--background' and '--access-token' are mutually exclusive and must not be specified together");
        }
    }

    static Integer getTimeoutParameter(boolean background, Integer timeoutHours) {
        if (background) {
            if (timeoutHours == null) {
                return 1;
            }
            if (timeoutHours < 1) {
                throw new ParameterException("Timeout must be at least 1 hour for background mode.");
            }
        } else {
            if (timeoutHours == null) {
                return 24;
            }
            if (timeoutHours < 0) {
                throw new ParameterException("Timeout must not be negative.");
            }
        }
        return timeoutHours;
    }

    public String getName() {
        return OPEN_DB_TUNNEL_COMMAND_NAME;
    }

    public String getGroup() {
        return "database tunnel";
    }

    @Override
    public String getVersion() {
        return "v3";
    }

    public void run() throws CommandException {
        if (this.background) {
            this.openTunnelInBackgroundProcess();
        } else {
            this.openTunnelInShellProcess();
        }
    }

    public Object runForStructuredOutput() throws CommandException {
        if (this.background) {
            return this.openTunnelInBackgroundProcessWithStructuredOutput();
        }
        throw new CommandException("Structured output (--output) is not supported for open-db-tunnel without --background");
    }

    private Object openTunnelInBackgroundProcessWithStructuredOutput() {
        TunnelSessionProperties tunnel = this.openTunnelInBackgroundProcess();
        return new OpenDbTunnelStructuredOutput(tunnel.getTunnelBackendInformation(), tunnel.getTunnelSessionId());
    }

    private TunnelSessionProperties openTunnelInBackgroundProcess() {
        this.jmxPort = BackgroundTunnelClient.evaluateJmxPort(this.jmxPort);
        TunnelParameters tunnelParameters = new TunnelParameters(this.getServiceName(), this.getHost(), this.getAccount(), this.schemaId, this.getUser());
        BackgroundTunnelClient backgroundTunnelClient = this.createBackgroundTunnelClient();
        TunnelSessionProperties tunnelSessionProperties = backgroundTunnelClient.openDbTunnel(this.jmxPort, tunnelParameters, this.timeoutHours * 60 * 60, this.getPassword());
        this.printTunnelInformation(tunnelSessionProperties.getTunnelBackendInformation(), tunnelSessionProperties.getTunnelSessionId());
        System.out.println();
        this.printTimeOutInformation("This tunnel session will close automatically in %s on %s at about %s.");
        System.out.println();
        System.out.println("For closing the tunnel, use the following command:");
        System.out.println("    neo close-db-tunnel --session-id " + tunnelSessionProperties.getTunnelSessionId());
        return tunnelSessionProperties;
    }

    private void openTunnelInShellProcess() {
        CommandTunnelHandler handler = this.createCommandTunnelHandler();
        handler.setHost(this.getHost());
        handler.setAccount(this.getAccount());
        handler.setSchemaId(this.schemaId);
        handler.setAccessToken(this.accessToken);
        handler.setUser(this.getUser());
        handler.setPassword(this.getPassword());
        handler.setTunnelTimeOutMinutes(this.timeoutHours * 60);
        handler.setServiceName(this.getServiceName());
        handler.addTunnelStateListener(new CommandTunnelStateListener(handler));
        handler.addTunnelMessageListener(new CommandTunnelMessageListener());
        System.out.println();
        System.out.println("Opening tunnel...");
        try {
            handler.openTunnel();
        }
        catch (IncompatibleServerVersionException e) {
            throw new CommandException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new CommandException("Failed to set up tunnel parameters", (Throwable)e);
        }
        this.setShutdownHook(handler);
        this.printTunnelInformation(handler.getTunnelBackendInformation(), null);
        this.printTimeOutInformation("This tunnel will close automatically in %s on %s at %s or when you close the shell.");
        this.waitForTermination();
        this.shutdown(handler);
    }

    private void printTunnelInformation(TunnelBackendInformation tunnelBackendInformation, String sessionId) {
        String schemaName;
        String dbUser;
        System.out.println("Tunnel opened.");
        System.out.println();
        System.out.println("Use these properties to connect to your schema:");
        System.out.println("  Host name        : localhost");
        System.out.println("  Database type    : " + tunnelBackendInformation.getDbIdentifier());
        System.out.println("  JDBC Url         : " + tunnelBackendInformation.getJdbcUrl());
        String instanceNumber = tunnelBackendInformation.getInstanceNumber();
        if (instanceNumber != null) {
            System.out.println("  Instance number  : " + instanceNumber);
        }
        if ((dbUser = tunnelBackendInformation.getUser()) != null) {
            System.out.println("  User             : " + dbUser);
        }
        String password = tunnelBackendInformation.getPassword();
        boolean isInitialPasswordOnly = tunnelBackendInformation.isInitialPasswordOnly();
        if (password != null) {
            if (isInitialPasswordOnly) {
                System.out.println("  Initial password : " + password);
            } else {
                System.out.println("  Password         : " + password);
            }
        }
        if ((schemaName = tunnelBackendInformation.getSchemaName()) != null && dbUser != null && !dbUser.equals(schemaName) && !this.isBackendASE(tunnelBackendInformation)) {
            System.out.println("  Schema name      : " + schemaName);
        }
        if (schemaName != null && this.isBackendASE(tunnelBackendInformation)) {
            System.out.println("  Database name    : " + schemaName);
        }
        if (sessionId != null) {
            System.out.println("  Session ID       : " + sessionId);
        }
        System.out.println();
        if (dbUser == null) {
            System.out.println("Use any valid database user for the tunnel.");
        }
        if (isInitialPasswordOnly && password != null) {
            System.out.println("Note: The password shown above is the initial password generated when you open the tunnel for the first time. You have to change the password on first login. You are responsible for choosing a strong password and keeping it secret.");
            System.out.println();
        }
    }

    private boolean isBackendASE(TunnelBackendInformation tunnelBackendInformation) {
        return tunnelBackendInformation.getDbIdentifier().equalsIgnoreCase(DBSpecificHelper.DbType.ase.getName());
    }

    protected CommandTunnelHandler createCommandTunnelHandler() {
        return new CommandTunnelHandler();
    }

    protected BackgroundTunnelClient createBackgroundTunnelClient() {
        return new BackgroundTunnelClient();
    }

    private void setShutdownHook(final CommandTunnelHandler manager) {
        Thread hook = new Thread(){

            @Override
            public void run() {
                OpenDbTunnelCommand.this.shutdown(manager);
            }
        };
        Runtime.getRuntime().addShutdownHook(hook);
    }

    private void shutdown(CommandTunnelHandler handler) {
        if (!this.isShutdown) {
            this.isShutdown = true;
            System.out.println("Closing tunnel...");
            handler.closeTunnel();
            System.out.println("Tunnel closed.");
        }
    }

    private void printTimeOutInformation(String message) {
        if (this.timeoutHours > 0) {
            Calendar calendar = Calendar.getInstance();
            int timeOut = this.timeoutHours;
            String timeOutString = Integer.toString(timeOut) + " " + (timeOut > 1 ? "hours" : "hour");
            calendar.add(10, timeOut);
            Date date = calendar.getTime();
            System.out.println(String.format(message, timeOutString, DateFormat.getDateInstance(2).format(date), DateFormat.getTimeInstance(3).format(date)));
        }
    }

    protected void waitForTermination() {
        BufferedReader br;
        try {
            br = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("Character set \"UTF-8\" is not supported. Cannot read from console.");
            return;
        }
        System.out.println("Press ENTER to close the tunnel now.");
        try {
            while (true) {
                String line;
                if ((line = br.readLine()) == null || this.isShutdown) {
                    continue;
                }
                System.out.println("Confirm that you want to close the tunnel: y/n");
                String confirmation = br.readLine();
                if ("y".equalsIgnoreCase(confirmation)) {
                    System.exit(0);
                }
                System.out.println("Press ENTER to close the tunnel now.");
            }
        }
        catch (IOException e) {
            throw new CommandException("Failed to read user input", (Throwable)e);
        }
    }

    @Override
    public void cleanup() throws CommandException {
    }

    private class CommandTunnelMessageListener
    implements TunnelMessageListener {
        private CommandTunnelMessageListener() {
        }

        @Override
        public void tunnelMessageReceived(int code, String message) {
            System.err.println();
            System.err.println(message);
        }
    }

    private class CommandTunnelStateListener
    implements TunnelStateListener {
        private CommandTunnelHandler handler;

        public CommandTunnelStateListener(CommandTunnelHandler handler) {
            this.handler = handler;
        }

        @Override
        public void tunnelStateChanged(TunnelStateListener.State newState) {
            switch (newState) {
                case opening: 
                case opened: 
                case closing: 
                case closed: {
                    break;
                }
                case terminated: {
                    OpenDbTunnelCommand.this.isShutdown = true;
                    System.exit(4);
                }
                case timeout: {
                    System.out.println("Timeout reached, closing tunnel.");
                    OpenDbTunnelCommand.this.shutdown(this.handler);
                    System.exit(0);
                }
            }
        }
    }
}

