/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.tunnel;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.persistence.commands.AbstractAccountCommand;
import com.sap.core.persistence.commands.entities.DbTunnelAccessTokenResponse;
import com.sap.core.tunnelcommands.framework.executor.CommandTunnelRequestExecutor;
import com.sap.core.tunnelcommands.framework.executor.HttpClientProvider;
import com.sap.core.tunnelcommands.framework.executor.HttpDeleteStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseContext;
import com.sap.core.tunnelcommands.framework.executor.HttpUriRequestStrategy;
import com.sap.core.tunnelcommands.framework.executor.ICommandTunnelCommand;
import com.sap.core.tunnelcommands.framework.executor.JsonConsumingStrategy;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;
import java.io.Console;

@Parameters(commandDescription="Revokes the database tunnel access granted to another subaccount.")
public class RevokeDbTunnelAccessCommand
extends AbstractAccountCommand {
    static final String REVOKE_DB_TUNNEL_ACCESS_COMMAND_NAME = "revoke-db-tunnel-access";
    @Parameter(names={"--access-token"}, description="Access token that identifies the grant")
    private String accessToken;
    @Parameter(names={"--silent"}, description="(optional) Suppresses the command line confirmation prompt")
    private boolean silent = false;

    public String getName() {
        return REVOKE_DB_TUNNEL_ACCESS_COMMAND_NAME;
    }

    public String getGroup() {
        return "database tunnel";
    }

    @Override
    public void init() throws CommandException {
        this.checkArgAccessToken();
        super.init();
    }

    public void checkArgAccessToken() {
        CheckHelper.checkArgSpecified(null, (String)"--access-token", (String)this.accessToken);
    }

    public void run() throws CommandException {
        if (!this.silent && !this.userConfirm()) {
            throw new CommandException("Operation was canceled by user.", 50);
        }
        this.executeRevokeSchemaAccess();
    }

    private boolean userConfirm() {
        Console cons = System.console();
        if (cons == null) {
            throw new CommandException("No console available. Please use parameter --silent to force the deletion without console.", 167);
        }
        System.out.println("Are you sure you want to permanently revoke the database tunnel grant? This operation cannot be reverted. (yes/no)");
        String answer = cons.readLine();
        return "yes".equalsIgnoreCase(answer) || "y".equalsIgnoreCase(answer);
    }

    private void executeRevokeSchemaAccess() {
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor((HttpUriRequestStrategy)new HttpDeleteStrategy(), (HttpResponseConsumingStrategy)new RevokeAccessConsumer(), (ICommandTunnelCommand)this, "dbtunnelaccesstoken/" + HttpClientProvider.encodeURLString((String)this.accessToken));
        helper.executeRequest();
    }

    class RevokeAccessConsumer
    extends JsonConsumingStrategy<DbTunnelAccessTokenResponse> {
        private RevokeAccessConsumer() {
            super(DbTunnelAccessTokenResponse.class);
        }

        public void consume(HttpResponseContext context) throws CommandException {
            int statusCode = context.getStatusCode();
            if (statusCode == 200) {
                DbTunnelAccessTokenResponse response = (DbTunnelAccessTokenResponse)this.getJsonObject(context);
                String databaseId = response.getDatabaseId();
                String toAccount = response.getToAccount();
                String out = "Revoked grant to open database tunnel from subaccount '" + toAccount + "' to database '" + databaseId + "'.";
                System.out.println(out);
            } else if (statusCode == 400) {
                this.throwCommandExceptionWithContentInfoAndLog(null, context);
            } else {
                super.consume(context);
            }
        }
    }
}

