/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.tunnel.api;

import com.sap.core.persistence.commands.tunnel.api.IncompatibleServerVersionException;
import com.sap.core.persistence.commands.tunnel.api.OpenDbTunnelConsumer;
import com.sap.core.persistence.commands.tunnel.api.TunnelBackendInformation;
import com.sap.core.persistence.commands.tunnel.api.TunnelMessageListener;
import com.sap.core.persistence.commands.tunnel.api.TunnelStateListener;
import com.sap.core.persistence.commands.tunnel.connection.DbTunnelManager;
import com.sap.core.persistence.commands.tunnel.entities.DbTunnelInformation;
import com.sap.core.tunnelcommands.framework.executor.BackendCall;
import com.sap.core.tunnelcommands.framework.executor.CommandTunnelRequestExecutor;
import com.sap.core.tunnelcommands.framework.executor.HttpClientProvider;
import com.sap.core.tunnelcommands.framework.executor.HttpDeleteStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpPutStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseContext;
import com.sap.core.tunnelcommands.framework.executor.HttpUriRequestStrategy;
import com.sap.core.tunnelcommands.framework.executor.ICommandTunnelCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class CommandTunnelHandler {
    private static final Logger LOGGER = Logger.getLogger(CommandTunnelHandler.class);
    public static final String OPEN_DEB_TUNNEL_COMMAND_VERSION = "v3";
    public static final int VALUE_NO_TIMEOUT = 0;
    private String account;
    private String host = "https://services.hana.ondemand.com";
    private String user;
    private String password;
    private String schemaId;
    private String accessToken;
    protected DbTunnelManager manager;
    private String serviceName;
    private int tunnelTimeOutMinutes = 1440;
    private int tunnelTimeOutSeconds = 0;
    private TimeUnit timeUnit = TimeUnit.MINUTES;
    private TunnelStateListener.State tunnelState;
    private TunnelBackendInformation tunnelBackendInformation;
    private ScheduledFuture<?> timeoutHook;
    private final List<TunnelStateListener> stateListeners = new ArrayList<TunnelStateListener>();
    private final List<TunnelMessageListener> messageListeners = new ArrayList<TunnelMessageListener>();
    private int requiredHanaInstance = -1;
    private int[] blockedHanaInstances = null;

    public void setAccount(String account) {
        this.account = account;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSchemaId(String schemaId) {
        this.schemaId = schemaId;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setTunnelTimeOutMinutes(int tunnelTimeOutMinutes) {
        this.tunnelTimeOutMinutes = tunnelTimeOutMinutes;
        this.timeUnit = TimeUnit.MINUTES;
    }

    public void setTunnelTimeOutSeconds(int tunnelTimeOutSeconds) {
        this.tunnelTimeOutSeconds = tunnelTimeOutSeconds;
        this.timeUnit = TimeUnit.SECONDS;
    }

    public void setRequiredHanaInstance(int requiredHanaInstance) {
        if (requiredHanaInstance < -1 || requiredHanaInstance > 99) {
            throw new IllegalArgumentException("The required HANA instance must not be smaller than -1 and larger than 99.");
        }
        this.requiredHanaInstance = requiredHanaInstance;
    }

    public void setBlockedHanaInstances(int[] blockedHanaInstances) {
        this.blockedHanaInstances = blockedHanaInstances;
    }

    public void openTunnel() throws IOException, IncompatibleServerVersionException {
        if (this.manager != null) {
            throw new IllegalStateException("Tunnel already opened");
        }
        this.setTunnelState(TunnelStateListener.State.opening);
        DbTunnelInformation tunnelInformation = this.performOpenTunnelRequest();
        this.manager = this.createDbTunnelManager(tunnelInformation);
        this.manager.setMessageHandler(new DbTunnelManager.MessageHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void fireMessage(int statusCode, String message) {
                List list = CommandTunnelHandler.this.messageListeners;
                synchronized (list) {
                    for (TunnelMessageListener messageListener : CommandTunnelHandler.this.messageListeners) {
                        messageListener.tunnelMessageReceived(statusCode, message);
                    }
                }
                if (statusCode == 101) {
                    CommandTunnelHandler.this.setTunnelState(TunnelStateListener.State.terminated);
                }
            }
        });
        this.manager.startTunnelClient();
        this.tunnelBackendInformation = this.manager.getTunnelBackendInformation();
        this.scheduleTimeoutHook();
        this.setTunnelState(TunnelStateListener.State.opened);
    }

    public void closeTunnel() {
        this.setTunnelState(TunnelStateListener.State.closing);
        this.cancelTimeout();
        this.manager.shutdown();
        this.manager = null;
        this.performCloseTunnelRequest();
        this.setTunnelState(TunnelStateListener.State.closed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTunnelStateListener(TunnelStateListener tunnelStateListener) {
        List<TunnelStateListener> list = this.stateListeners;
        synchronized (list) {
            this.stateListeners.add(tunnelStateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTunnelStateListener(TunnelStateListener tunnelStateListener) {
        List<TunnelStateListener> list = this.stateListeners;
        synchronized (list) {
            this.stateListeners.remove(tunnelStateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTunnelMessageListener(TunnelMessageListener tunnelMessageListener) {
        List<TunnelMessageListener> list = this.messageListeners;
        synchronized (list) {
            this.messageListeners.add(tunnelMessageListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTunnelMessageListener(TunnelMessageListener tunnelMessageListener) {
        List<TunnelMessageListener> list = this.messageListeners;
        synchronized (list) {
            this.messageListeners.remove(tunnelMessageListener);
        }
    }

    public TunnelBackendInformation getTunnelBackendInformation() {
        return this.tunnelBackendInformation;
    }

    protected void scheduleTimeoutHook() {
        int tunnelTimeOut = this.tunnelTimeOutMinutes;
        if (TimeUnit.SECONDS.equals((Object)this.timeUnit)) {
            tunnelTimeOut = this.tunnelTimeOutSeconds;
        }
        if (tunnelTimeOut > 0) {
            Runnable hook = new Runnable(){

                @Override
                public void run() {
                    CommandTunnelHandler.this.manager.shutdown();
                    CommandTunnelHandler.this.setTunnelState(TunnelStateListener.State.timeout);
                }
            };
            ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread result = Executors.defaultThreadFactory().newThread(r);
                    result.setDaemon(true);
                    return result;
                }
            });
            this.timeoutHook = scheduler.schedule(hook, (long)tunnelTimeOut, this.timeUnit);
        }
    }

    protected void setTunnelState(TunnelStateListener.State newState) {
        if (newState != this.tunnelState) {
            this.notifyTunnelStateChange(this.tunnelState, newState);
            this.tunnelState = newState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTunnelStateChange(TunnelStateListener.State oldState, TunnelStateListener.State newState) {
        List<TunnelStateListener> list = this.stateListeners;
        synchronized (list) {
            for (TunnelStateListener tunnelStateListener : this.stateListeners) {
                tunnelStateListener.tunnelStateChanged(newState);
            }
        }
    }

    protected void cancelTimeout() {
        if (this.timeoutHook != null) {
            this.timeoutHook.cancel(true);
            this.timeoutHook = null;
        }
    }

    private String getUriPath() {
        if (this.schemaId != null) {
            return "dbtunnel/schemaId/" + HttpClientProvider.encodeURLString((String)this.schemaId);
        }
        return "dbtunnel/accesstoken/" + HttpClientProvider.encodeURLString((String)this.accessToken);
    }

    protected DbTunnelManager createDbTunnelManager(DbTunnelInformation tunnelInformation) throws IOException {
        return new DbTunnelManager(tunnelInformation, this.host, this.requiredHanaInstance, this.blockedHanaInstances);
    }

    private DbTunnelInformation performOpenTunnelRequest() {
        OpenDbTunnelConsumer openDbTunnelConsumer = new OpenDbTunnelConsumer();
        BackendCall backendCall = new BackendCall("open-db-tunnel", this.host, this.account, this.user, this.password, this.serviceName, OPEN_DEB_TUNNEL_COMMAND_VERSION);
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor((HttpUriRequestStrategy)new HttpPutStrategy(), (HttpResponseConsumingStrategy)openDbTunnelConsumer, (ICommandTunnelCommand)backendCall, this.getUriPath());
        helper.executeRequest();
        return openDbTunnelConsumer.getTunnelInformation();
    }

    private void performCloseTunnelRequest() {
        HttpResponseConsumingStrategy closeTunnelConsumer = new HttpResponseConsumingStrategy(){

            public void consume(HttpResponseContext context) throws CommandException {
                switch (context.getStatusCode()) {
                    case 200: 
                    case 405: {
                        return;
                    }
                }
                LOGGER.warn((Object)("Unexpected response from backend for tunnel close request: " + context.getResponse().getStatusLine()));
            }
        };
        BackendCall backendCall = new BackendCall("open-db-tunnel", this.host, this.account, this.user, this.password, this.serviceName, OPEN_DEB_TUNNEL_COMMAND_VERSION);
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor((HttpUriRequestStrategy)new HttpDeleteStrategy(), closeTunnelConsumer, (ICommandTunnelCommand)backendCall, this.getUriPath());
        helper.executeRequest();
    }

    public void resetTunnelTimeOutSeconds(int newTunnelTimeOutSeconds) {
        this.cancelTimeout();
        this.setTunnelTimeOutSeconds(newTunnelTimeOutSeconds);
        this.scheduleTimeoutHook();
    }
}

