/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.tunnel.api;

import com.sap.core.persistence.commands.tunnel.api.IncompatibleServerVersionException;
import com.sap.core.persistence.commands.tunnel.entities.DbTunnelInformation;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseContext;
import com.sap.core.tunnelcommands.framework.executor.JsonConsumingStrategy;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import org.apache.log4j.Logger;

class OpenDbTunnelConsumer
extends JsonConsumingStrategy<DbTunnelInformation> {
    private final Logger LOGGER = Logger.getLogger(OpenDbTunnelConsumer.class);
    private DbTunnelInformation tunnelInformation;

    public OpenDbTunnelConsumer() {
        super(DbTunnelInformation.class);
    }

    public void consume(HttpResponseContext context) throws CommandException {
        int statusCode = context.getResponse().getStatusLine().getStatusCode();
        if (statusCode == 200) {
            this.tunnelInformation = (DbTunnelInformation)this.getJsonObject(context);
            this.LOGGER.debug((Object)("Retrieved data from REST endpoint: " + this.tunnelInformation.toString()));
        } else if (statusCode == 400) {
            String responseContentString = context.getResponseContentString();
            if (responseContentString.contains("invalid protocol version")) {
                throw new IncompatibleServerVersionException(responseContentString);
            }
            this.throwCommandExceptionWithContentInfoAndLog("Failed to connect to the backend: bad request", context);
        } else {
            super.consume(context);
        }
    }

    public DbTunnelInformation getTunnelInformation() {
        return this.tunnelInformation;
    }
}

