/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.tunnel.background;

import com.sap.core.persistence.commands.jmx.client.JmxDaemonClient;
import com.sap.core.persistence.commands.tunnel.background.BackgroundTunnelManagerException;
import com.sap.core.persistence.commands.tunnel.background.BackgroundTunnelManagerMBean;
import com.sap.core.persistence.commands.tunnel.background.BackgroundTunnelManagerMBeanImpl;
import com.sap.core.persistence.commands.tunnel.background.BackgroundTunnelSessionCloseResult;
import com.sap.core.persistence.commands.tunnel.background.TunnelParameters;
import com.sap.core.persistence.commands.tunnel.background.TunnelSessionProperties;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ServerSocket;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class BackgroundTunnelClient {
    private static final int NUMBER_RETRIES_FOR_SHUTDOWN_WAIT = 5;
    public static final int DEFAULT_JMX_PORT = 1919;
    private static Logger logger = Logger.getLogger(BackgroundTunnelClient.class);

    public TunnelSessionProperties openDbTunnel(int jmxPort, TunnelParameters tunnelParameters, int tunnelTimeOutSeconds, String password) {
        TunnelSessionProperties tunnelSessionProperties;
        JmxDaemonClient<BackgroundTunnelManagerMBean> backgroundProcessClient = this.getBackgroundProcessClient(jmxPort);
        try {
            BackgroundTunnelManagerMBean tunnelManagerProxy = backgroundProcessClient.connectToDaemon();
            this.logAndPrintToSysout((Priority)Level.INFO, "Invoking open tunnel command on background process ...");
            logger.info((Object)tunnelParameters);
            tunnelSessionProperties = tunnelManagerProxy.openDbTunnel(tunnelParameters, tunnelTimeOutSeconds, password);
        }
        catch (UndeclaredThrowableException e) {
            throw new CommandException("Cannot open tunnel session.", (Throwable)e);
        }
        catch (BackgroundTunnelManagerException e) {
            throw new CommandException("Cannot open tunnel session.", (Throwable)e);
        }
        finally {
            this.doCloseJmxConnection(backgroundProcessClient);
        }
        logger.info((Object)("Succeeded to open tunnel session '" + tunnelSessionProperties.getTunnelSessionId() + "'"));
        return tunnelSessionProperties;
    }

    private void doCloseJmxConnection(JmxDaemonClient<BackgroundTunnelManagerMBean> backgroundProcessClient) {
        if (backgroundProcessClient != null) {
            backgroundProcessClient.close();
        }
    }

    public BackgroundTunnelSessionCloseResult closeAllDbTunnels(int jmxPort) {
        JmxDaemonClient<BackgroundTunnelManagerMBean> backgroundProcessClient = this.getBackgroundProcessClient(jmxPort);
        try {
            BackgroundTunnelManagerMBean tunnelManagerProxy = backgroundProcessClient.connectToDaemonIfRunning();
            if (tunnelManagerProxy == null) {
                BackgroundTunnelSessionCloseResult backgroundTunnelSessionCloseResult = BackgroundTunnelSessionCloseResult.TUNNEL_MANAGER_IS_DOWN;
                return backgroundTunnelSessionCloseResult;
            }
            this.logAndPrintToSysout((Priority)Level.INFO, "Invoking close all tunnels command on background process ...");
            tunnelManagerProxy.closeAllDbTunnels();
        }
        catch (UndeclaredThrowableException e) {
            logger.error((Object)"Cannot call TunnelManagerProxy", (Throwable)e);
            BackgroundTunnelSessionCloseResult backgroundTunnelSessionCloseResult = BackgroundTunnelSessionCloseResult.TUNNEL_MANAGER_IS_DOWN;
            return backgroundTunnelSessionCloseResult;
        }
        catch (BackgroundTunnelManagerException e) {
            throw new CommandException("Cannot close all tunnels", (Throwable)e);
        }
        finally {
            this.doCloseJmxConnection(backgroundProcessClient);
        }
        if (this.waitForBackgroundProcessShutdown(jmxPort)) {
            return BackgroundTunnelSessionCloseResult.TUNNEL_MANAGER_HAS_SHUT_DOWN;
        }
        return BackgroundTunnelSessionCloseResult.TUNNEL_CLOSED_ALL;
    }

    public BackgroundTunnelSessionCloseResult closeDbTunnelSession(int jmxPort, String tunnelSessionId) {
        BackgroundTunnelSessionCloseResult closeDbTunnelResult;
        JmxDaemonClient<BackgroundTunnelManagerMBean> backgroundProcessClient = this.getBackgroundProcessClient(jmxPort);
        try {
            BackgroundTunnelManagerMBean tunnelManagerProxy = backgroundProcessClient.connectToDaemonIfRunning();
            if (tunnelManagerProxy == null) {
                BackgroundTunnelSessionCloseResult backgroundTunnelSessionCloseResult = BackgroundTunnelSessionCloseResult.TUNNEL_MANAGER_IS_DOWN;
                return backgroundTunnelSessionCloseResult;
            }
            this.logAndPrintToSysout((Priority)Level.INFO, "Invoking close tunnel command on background process ...");
            closeDbTunnelResult = tunnelManagerProxy.closeDbTunnelSession(tunnelSessionId);
            logger.info((Object)("Close db tunnel result is " + (Object)((Object)closeDbTunnelResult)));
        }
        catch (UndeclaredThrowableException e) {
            logger.error((Object)"Cannot call TunnelManagerProxy", (Throwable)e);
            BackgroundTunnelSessionCloseResult backgroundTunnelSessionCloseResult = BackgroundTunnelSessionCloseResult.TUNNEL_MANAGER_IS_DOWN;
            return backgroundTunnelSessionCloseResult;
        }
        catch (BackgroundTunnelManagerException e) {
            throw new CommandException("Cannot close tunnel", (Throwable)e);
        }
        finally {
            this.doCloseJmxConnection(backgroundProcessClient);
        }
        if (closeDbTunnelResult.equals((Object)BackgroundTunnelSessionCloseResult.TUNNEL_CLOSED_ALL) && this.waitForBackgroundProcessShutdown(jmxPort)) {
            return BackgroundTunnelSessionCloseResult.TUNNEL_MANAGER_HAS_SHUT_DOWN;
        }
        return closeDbTunnelResult;
    }

    public static int evaluateJmxPort(int jmxPort) {
        if (jmxPort == 0) {
            logger.debug((Object)"Using default JMX port '1919'.");
            return 1919;
        }
        if (jmxPort < 0) {
            throw new CommandException("JMX port must not be negative (was " + jmxPort + "').");
        }
        return jmxPort;
    }

    public static String getBackgroundProcessConsoleLogfileName(int jmxPort) {
        return "console_tunnel_background_" + jmxPort + ".log";
    }

    private boolean waitForBackgroundProcessShutdown(int jmxPort) {
        ServerSocket socket = null;
        for (int numberTries = 0; socket == null && numberTries < 5; ++numberTries) {
            socket = this.tryToOpenSocket(jmxPort);
            this.doSleep(1000L);
        }
        if (socket == null) {
            this.logAndPrintToSysout((Priority)Level.WARN, "Background process has not shut down after 5 seconds.");
            return false;
        }
        logger.info((Object)"Background process has shut down.");
        return true;
    }

    private void doSleep(long timeInMillis) {
        try {
            Thread.sleep(timeInMillis);
        }
        catch (InterruptedException e) {
            logger.debug((Object)("InterruptedException while waiting." + e.getMessage()));
        }
    }

    private ServerSocket tryToOpenSocket(int jmxPort) {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(jmxPort);
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return socket;
    }

    protected JmxDaemonClient<BackgroundTunnelManagerMBean> getBackgroundProcessClient(int jmxPort) {
        if (jmxPort <= 0) {
            throw new IllegalArgumentException("JMX port must be greater than 0 (was '" + jmxPort + "'). Make sure you call evaluatejmxPort().");
        }
        return new JmxDaemonClient<BackgroundTunnelManagerMBean>(BackgroundTunnelManagerMBean.class, BackgroundTunnelManagerMBeanImpl.class, jmxPort);
    }

    private void logAndPrintToSysout(Priority priority, String message) {
        String logLevelString = priority.equals((Object)Level.INFO) ? "" : priority.toString() + ": ";
        System.out.println(logLevelString + message);
        logger.log(priority, (Object)message);
    }
}

