/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.tunnel.background;

import com.sap.core.persistence.commands.tunnel.api.CommandTunnelHandler;
import com.sap.core.persistence.commands.tunnel.api.IncompatibleServerVersionException;
import com.sap.core.persistence.commands.tunnel.api.TunnelBackendInformation;
import com.sap.core.persistence.commands.tunnel.api.TunnelMessageListener;
import com.sap.core.persistence.commands.tunnel.api.TunnelStateListener;
import com.sap.core.persistence.commands.tunnel.background.BackgroundTunnelManagerException;
import com.sap.core.persistence.commands.tunnel.background.BackgroundTunnelSessionCloseResult;
import com.sap.core.persistence.commands.tunnel.background.BackgroundTunnelShutdownException;
import com.sap.core.persistence.commands.tunnel.background.BackgroundTunnelStateListener;
import com.sap.core.persistence.commands.tunnel.background.TunnelParameters;
import com.sap.core.persistence.commands.tunnel.background.TunnelSessionProperties;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import org.apache.log4j.Logger;

public class BackgroundTunnelHandler {
    private final TunnelParameters tunnelParameters;
    private final BackgroundTunnelStateListener backgroundTunnelManagerListener;
    protected final HashMap<String, Calendar> tunnelSessionIdToExpiryDate = new HashMap();
    private CommandTunnelStateListener commandTunnelStateListener;
    private final CommandTunnelMessageListener commandTunnelMessageListener;
    private CommandTunnelHandler commandTunnelHandler = null;
    private boolean isCommandTunnelHandlerSetUp = false;
    private volatile boolean isTunnelClosed = false;
    private static final Logger logger = Logger.getLogger(BackgroundTunnelHandler.class);

    public BackgroundTunnelHandler(TunnelParameters tunnelParameters, BackgroundTunnelStateListener backgroundTunnelManagerListener) {
        this.tunnelParameters = tunnelParameters;
        this.backgroundTunnelManagerListener = backgroundTunnelManagerListener;
        this.commandTunnelStateListener = this.getCommandTunnelStateListener();
        this.commandTunnelMessageListener = new CommandTunnelMessageListener();
    }

    CommandTunnelStateListener getCommandTunnelStateListener() {
        if (this.commandTunnelStateListener == null) {
            this.commandTunnelStateListener = new CommandTunnelStateListener();
        }
        return this.commandTunnelStateListener;
    }

    Collection<String> getTunnelSessionIds() {
        return this.tunnelSessionIdToExpiryDate.keySet();
    }

    protected TunnelSessionProperties createTunnelSession(String password, int tunnelTimeOutSeconds) throws BackgroundTunnelManagerException, BackgroundTunnelShutdownException {
        if (this.isTunnelClosed) {
            throw new BackgroundTunnelShutdownException("Tunnel is closed but BackgroundTunnelHandler is not yet removed from the BackgroundTunnelStore.");
        }
        Calendar currentDate = this.getCurrentDate();
        Calendar expiryDate = BackgroundTunnelHandler.getExpiryDate(currentDate, tunnelTimeOutSeconds);
        if (this.isCommandTunnelHandlerSetUp) {
            int newTunnelTimeOutSeconds = this.evaluateTunnelTimeOut(currentDate, expiryDate);
            this.getCommandTunnelHandler().resetTunnelTimeOutSeconds(newTunnelTimeOutSeconds);
        } else {
            this.createCommandTunnelHandlerAndOpenTunnel(password, tunnelTimeOutSeconds);
        }
        TunnelBackendInformation tunnelBackendInformation = this.getCommandTunnelHandler().getTunnelBackendInformation();
        if (tunnelBackendInformation == null) {
            throw new BackgroundTunnelManagerException("TunnelBackendInformation is null.");
        }
        if (this.isTunnelClosed) {
            throw new BackgroundTunnelManagerException("Tunnel closed unexpectedly.");
        }
        String tunnelSessionId = this.getTunnelSessionId();
        this.tunnelSessionIdToExpiryDate.put(tunnelSessionId, expiryDate);
        return new TunnelSessionProperties(tunnelSessionId, tunnelBackendInformation);
    }

    static Calendar getExpiryDate(Calendar currentDate, int tunnelTimeOutSeconds) {
        Calendar expiryDate = Calendar.getInstance();
        expiryDate.setTimeInMillis(currentDate.getTimeInMillis());
        if (tunnelTimeOutSeconds == 0) {
            expiryDate.setTimeInMillis(0L);
        } else {
            expiryDate.add(13, tunnelTimeOutSeconds);
        }
        return expiryDate;
    }

    int evaluateTunnelTimeOut(Calendar currentDate, Calendar expiryDate) {
        Calendar latestExpiryDate = expiryDate;
        if (latestExpiryDate.getTimeInMillis() == 0L) {
            return 0;
        }
        for (Calendar sessionExpiryDate : this.tunnelSessionIdToExpiryDate.values()) {
            if (!sessionExpiryDate.after(latestExpiryDate)) continue;
            latestExpiryDate = sessionExpiryDate;
        }
        return (int)((latestExpiryDate.getTimeInMillis() - currentDate.getTimeInMillis()) / 1000L);
    }

    Calendar getCurrentDate() {
        return Calendar.getInstance();
    }

    String getTunnelSessionId() {
        return UUID.randomUUID().toString();
    }

    public boolean isTunnelClosed() {
        return this.isTunnelClosed;
    }

    protected void closeDbTunnel() {
        if (this.isTunnelClosed) {
            logger.debug((Object)"Tunnel is closed but BackgroundTunnelHandler is not yet removed from the BackgroundTunnelStore.");
        } else {
            this.isTunnelClosed = true;
            this.getCommandTunnelHandler().closeTunnel();
        }
    }

    BackgroundTunnelSessionCloseResult closeDbTunnelSession(String tunnelSessionId) {
        if (this.isTunnelClosed) {
            return BackgroundTunnelSessionCloseResult.TUNNEL_CLOSED;
        }
        this.tunnelSessionIdToExpiryDate.remove(tunnelSessionId);
        if (this.tunnelSessionIdToExpiryDate.isEmpty()) {
            this.getCommandTunnelHandler().closeTunnel();
            this.isTunnelClosed = true;
            return BackgroundTunnelSessionCloseResult.TUNNEL_CLOSED;
        }
        return BackgroundTunnelSessionCloseResult.TUNNEL_SESSION_CLOSED;
    }

    private void createCommandTunnelHandlerAndOpenTunnel(String password, int tunnelTimeOutSeconds) throws BackgroundTunnelManagerException {
        this.setupCommandHandler(password, tunnelTimeOutSeconds);
        try {
            this.getCommandTunnelHandler().openTunnel();
        }
        catch (IncompatibleServerVersionException e) {
            throw new BackgroundTunnelManagerException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new BackgroundTunnelManagerException("Failed to set up tunnel parameters", e);
        }
    }

    protected CommandTunnelHandler getCommandTunnelHandler() {
        if (this.commandTunnelHandler == null) {
            this.commandTunnelHandler = new CommandTunnelHandler();
        }
        return this.commandTunnelHandler;
    }

    protected TunnelParameters getTunnelParameters() {
        return this.tunnelParameters;
    }

    private void setupCommandHandler(String password, int tunnelTimeOutSeconds) {
        this.getCommandTunnelHandler().setServiceName(this.tunnelParameters.getServiceName());
        this.getCommandTunnelHandler().setHost(this.tunnelParameters.getHost());
        this.getCommandTunnelHandler().setAccount(this.tunnelParameters.getAccount());
        this.getCommandTunnelHandler().setSchemaId(this.tunnelParameters.getSchema());
        this.getCommandTunnelHandler().setUser(this.tunnelParameters.getUser());
        this.getCommandTunnelHandler().setPassword(password);
        this.getCommandTunnelHandler().setTunnelTimeOutSeconds(tunnelTimeOutSeconds);
        this.getCommandTunnelHandler().addTunnelStateListener(this.commandTunnelStateListener);
        this.getCommandTunnelHandler().addTunnelMessageListener(this.commandTunnelMessageListener);
        this.isCommandTunnelHandlerSetUp = true;
    }

    private class CommandTunnelMessageListener
    implements TunnelMessageListener {
        private CommandTunnelMessageListener() {
        }

        @Override
        public void tunnelMessageReceived(int code, String message) {
            logger.info((Object)message);
        }
    }

    private class CommandTunnelStateListener
    implements TunnelStateListener {
        private CommandTunnelStateListener() {
        }

        @Override
        public void tunnelStateChanged(TunnelStateListener.State newState) {
            switch (newState) {
                case opening: 
                case opened: {
                    return;
                }
                case closing: 
                case closed: 
                case terminated: 
                case timeout: {
                    BackgroundTunnelHandler.this.isTunnelClosed = true;
                }
            }
            BackgroundTunnelHandler.this.backgroundTunnelManagerListener.tunnelStateChanged(BackgroundTunnelHandler.this.tunnelParameters, BackgroundTunnelHandler.this.getTunnelSessionIds(), newState);
        }
    }
}

