/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.tunnel.background;

import com.sap.core.persistence.commands.jmx.server.DaemonActivityListener;
import com.sap.core.persistence.commands.tunnel.api.TunnelStateListener;
import com.sap.core.persistence.commands.tunnel.background.BackgroundTunnelManagerException;
import com.sap.core.persistence.commands.tunnel.background.BackgroundTunnelSessionCloseResult;
import com.sap.core.persistence.commands.tunnel.background.BackgroundTunnelShutdownException;
import com.sap.core.persistence.commands.tunnel.background.BackgroundTunnelStateListener;
import com.sap.core.persistence.commands.tunnel.background.BackgroundTunnelStore;
import com.sap.core.persistence.commands.tunnel.background.TunnelParameters;
import com.sap.core.persistence.commands.tunnel.background.TunnelSessionProperties;
import java.util.Collection;
import org.apache.log4j.Logger;

public class BackgroundTunnelManager {
    private static final int NUMBER_ATTEMPTS_FOR_OPEN_IF_TUNNEL_IS_SHUTDOWN = 2;
    private BackgroundTunnelStore backgroundTunnelStore = null;
    private BackgroundTunnelStateListener tunnelDownEventListener = null;
    private DaemonActivityListener backgroundActivityListener;
    private final Object serializer = new Object();
    private static final Logger logger = Logger.getLogger(BackgroundTunnelManager.class);

    public BackgroundTunnelManager(DaemonActivityListener backgroundActivityListener) {
        this.backgroundActivityListener = backgroundActivityListener;
    }

    TunnelSessionProperties openDbTunnel(TunnelParameters tunnelParameters, int tunnelTimeOutSeconds, String password) throws BackgroundTunnelManagerException {
        TunnelSessionProperties tunnelSessionProperties = null;
        int numberOfTries = 0;
        while (tunnelSessionProperties == null) {
            block5: {
                ++numberOfTries;
                try {
                    tunnelSessionProperties = this.doOpenTunnelSynchronized(tunnelParameters, tunnelTimeOutSeconds, password);
                }
                catch (BackgroundTunnelShutdownException e) {
                    if (numberOfTries != 2) break block5;
                    throw new BackgroundTunnelManagerException("Failed to open tunnel after 2 retries.", e);
                }
            }
            if (tunnelSessionProperties != null || numberOfTries >= 2) continue;
            try {
                logger.info((Object)("Tunnel is shutting down. Waiting 2 seconds and then retrying to open tunnel with parameters: " + tunnelParameters));
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                logger.debug((Object)("InterruptedException while waiting for retry: " + e.getMessage()));
            }
        }
        return tunnelSessionProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TunnelSessionProperties doOpenTunnelSynchronized(TunnelParameters tunnelParameters, int tunnelTimeOutSeconds, String password) throws BackgroundTunnelManagerException, BackgroundTunnelShutdownException {
        logger.info((Object)("Opening tunnel with parameters: " + tunnelParameters));
        Object object = this.serializer;
        synchronized (object) {
            TunnelSessionProperties tunnelSessionProperties;
            try {
                TunnelSessionProperties tunnelSessionProperties2 = this.getBackgroundTunnelStore().createTunnelSession(tunnelParameters, password, tunnelTimeOutSeconds, this.getTunnelDownEventListener());
                logger.info((Object)("Finished opening tunnel with parameters: " + tunnelParameters));
                tunnelSessionProperties = tunnelSessionProperties2;
                this.updateBackgroundTunnelStatus();
            }
            catch (Throwable throwable) {
                this.updateBackgroundTunnelStatus();
                throw throwable;
            }
            return tunnelSessionProperties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BackgroundTunnelSessionCloseResult closeDbTunnelSession(String tunnelSessionId) throws BackgroundTunnelManagerException {
        logger.info((Object)("Closing tunnel with session id: " + tunnelSessionId));
        Object object = this.serializer;
        synchronized (object) {
            BackgroundTunnelSessionCloseResult result = null;
            try {
                result = this.getBackgroundTunnelStore().closeDbTunnelSession(tunnelSessionId);
                logger.info((Object)("Finished closing tunnel with result: " + (Object)((Object)result)));
            }
            finally {
                this.updateBackgroundTunnelStatus();
                if (this.getBackgroundTunnelStore().isEmpty()) {
                    result = BackgroundTunnelSessionCloseResult.TUNNEL_CLOSED_ALL;
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeAllDbTunnels() throws BackgroundTunnelManagerException {
        logger.info((Object)"Closing all tunnels");
        Object object = this.serializer;
        synchronized (object) {
            try {
                this.getBackgroundTunnelStore().closeAllDbTunnels();
            }
            finally {
                this.updateBackgroundTunnelStatus();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processTunnelHandlerNotification(TunnelParameters tunnelParameters, Collection<String> tunnelSessionIds) {
        logger.info((Object)("Processing TunnelHandlerNotification: " + tunnelParameters));
        Object object = this.serializer;
        synchronized (object) {
            logger.info((Object)("Unregistering TunnelHandler with sessionIds: " + tunnelSessionIds));
            this.getBackgroundTunnelStore().unregisterBackgroundTunnelHandler(tunnelParameters, tunnelSessionIds);
            this.updateBackgroundTunnelStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBackgroundTunnelStatus() {
        Object object = this.serializer;
        synchronized (object) {
            boolean hasOpenBackgroundTunnels = !this.getBackgroundTunnelStore().isEmpty();
            this.backgroundActivityListener.notifyOfBackgroundActivity(hasOpenBackgroundTunnels);
        }
    }

    protected BackgroundTunnelStore getBackgroundTunnelStore() {
        if (this.backgroundTunnelStore == null) {
            this.backgroundTunnelStore = new BackgroundTunnelStore();
        }
        return this.backgroundTunnelStore;
    }

    protected BackgroundTunnelStateListener getTunnelDownEventListener() {
        if (this.tunnelDownEventListener == null) {
            this.tunnelDownEventListener = new TunnelDownEventListener();
        }
        return this.tunnelDownEventListener;
    }

    public class TunnelDownEventListener
    implements BackgroundTunnelStateListener {
        @Override
        public void tunnelStateChanged(TunnelParameters tunnelParameters, Collection<String> tunnelSessionIds, TunnelStateListener.State newState) {
            switch (newState) {
                case opening: 
                case opened: 
                case closing: {
                    return;
                }
                case closed: {
                    logger.debug((Object)("Tunnel closed. " + tunnelParameters));
                    break;
                }
                case terminated: {
                    logger.debug((Object)("Tunnel terminated, closing tunnel. " + tunnelParameters));
                    break;
                }
                case timeout: {
                    logger.debug((Object)("Tunnel timeout reached, closing tunnel. " + tunnelParameters));
                }
            }
            BackgroundTunnelManager.this.processTunnelHandlerNotification(tunnelParameters, tunnelSessionIds);
        }
    }
}

