/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.tunnel.background;

import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class BackgroundTunnelPasswordHash {
    public static final String ALGORITHM = "PBKDF2WithHmacSHA1";
    public static final int NUMBER_OF_HASH_BYTES = 48;
    public static final int NUMBER_OF_SALT_BYTES = 48;
    public static final int NUMBER_OF_ITERATIONS = 1001;
    public static final int HASH_POSITION = 2;
    public static final int SALT_POSITION = 1;
    public static final int ITERATION_POSITION = 0;

    public static String createPasswordHash(String password) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return BackgroundTunnelPasswordHash.createPasswordHash(password.toCharArray());
    }

    public static String createPasswordHash(char[] password) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[48];
        random.nextBytes(salt);
        byte[] passwordHash = BackgroundTunnelPasswordHash.pbkdf2(password, salt, 1001, 48);
        return "1001:" + BackgroundTunnelPasswordHash.fromByteArrayToHex(salt) + ":" + BackgroundTunnelPasswordHash.fromByteArrayToHex(passwordHash);
    }

    public static boolean validatePassword(String password, String existingHash) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return BackgroundTunnelPasswordHash.validatePassword(password.toCharArray(), existingHash);
    }

    public static boolean validatePassword(char[] password, String existingHash) throws NoSuchAlgorithmException, InvalidKeySpecException {
        String[] parts = existingHash.split(":");
        int iterations = Integer.parseInt(parts[0]);
        byte[] salt = BackgroundTunnelPasswordHash.fromHexToByteArray(parts[1]);
        byte[] passwordHash = BackgroundTunnelPasswordHash.fromHexToByteArray(parts[2]);
        byte[] testHash = BackgroundTunnelPasswordHash.pbkdf2(password, salt, iterations, passwordHash.length);
        return BackgroundTunnelPasswordHash.slowEquals(passwordHash, testHash);
    }

    private static boolean slowEquals(byte[] hash1, byte[] hash2) {
        int diff = hash1.length ^ hash2.length;
        for (int i = 0; i < hash1.length && i < hash2.length; ++i) {
            diff |= hash1[i] ^ hash2[i];
        }
        return diff == 0;
    }

    private static byte[] pbkdf2(char[] password, byte[] salt, int iterations, int bytes) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PBEKeySpec spec = new PBEKeySpec(password, salt, iterations, bytes * 8);
        SecretKeyFactory skf = SecretKeyFactory.getInstance(ALGORITHM);
        return skf.generateSecret(spec).getEncoded();
    }

    private static byte[] fromHexToByteArray(String hex) {
        byte[] byteArray = new byte[hex.length() / 2];
        for (int i = 0; i < byteArray.length; ++i) {
            byteArray[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return byteArray;
    }

    private static String fromByteArrayToHex(byte[] byteArray) {
        BigInteger bigInteger = new BigInteger(1, byteArray);
        String hex = bigInteger.toString(16);
        int paddingLength = byteArray.length * 2 - hex.length();
        if (paddingLength > 0) {
            return String.format("%0" + paddingLength + "d", 0) + hex;
        }
        return hex;
    }
}

