/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.tunnel.background;

import com.sap.core.persistence.commands.tunnel.background.BackgroundTunnelHandler;
import com.sap.core.persistence.commands.tunnel.background.BackgroundTunnelManagerException;
import com.sap.core.persistence.commands.tunnel.background.BackgroundTunnelPasswordHash;
import com.sap.core.persistence.commands.tunnel.background.BackgroundTunnelSessionCloseResult;
import com.sap.core.persistence.commands.tunnel.background.BackgroundTunnelShutdownException;
import com.sap.core.persistence.commands.tunnel.background.BackgroundTunnelStateListener;
import com.sap.core.persistence.commands.tunnel.background.TunnelParameters;
import com.sap.core.persistence.commands.tunnel.background.TunnelSessionProperties;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BackgroundTunnelStore {
    private final Map<TunnelParameters, List<PasswordHashAndHandler>> tunnelParametersToPasswordHashAndHandlerMap = new HashMap<TunnelParameters, List<PasswordHashAndHandler>>();
    private final Map<String, TunnelParametersAndPasswordHash> tunnelSessionToTunnelParametersAndPasswordHashMap = new HashMap<String, TunnelParametersAndPasswordHash>();

    public boolean isEmpty() {
        return this.tunnelParametersToPasswordHashAndHandlerMap.isEmpty();
    }

    public TunnelSessionProperties createTunnelSession(TunnelParameters tunnelParameters, String password, int tunnelTimeOutSeconds, BackgroundTunnelStateListener tunnelDownEventListener) throws BackgroundTunnelManagerException, BackgroundTunnelShutdownException {
        boolean needToCreateBackgroundTunnelHandler;
        BackgroundTunnelHandler handler;
        PasswordHashAndHandler passwordHashAndHandler = this.getPasswordHashAndHandler(tunnelParameters, password, null);
        if (passwordHashAndHandler != null && (handler = passwordHashAndHandler.getBackgroundTunnelHandler()) != null && handler.isTunnelClosed()) {
            Collection<String> tunnelSessionIds = handler.getTunnelSessionIds();
            this.unregisterBackgroundTunnelHandler(tunnelParameters, tunnelSessionIds);
            passwordHashAndHandler = null;
        }
        boolean bl = needToCreateBackgroundTunnelHandler = passwordHashAndHandler == null;
        if (needToCreateBackgroundTunnelHandler) {
            passwordHashAndHandler = this.createBackgroundTunnelHandler(tunnelParameters, password, tunnelDownEventListener);
        }
        TunnelSessionProperties tunnelSessionProperties = passwordHashAndHandler.getBackgroundTunnelHandler().createTunnelSession(password, tunnelTimeOutSeconds);
        if (needToCreateBackgroundTunnelHandler) {
            ArrayList<PasswordHashAndHandler> passwordHashAndHandlers = new ArrayList<PasswordHashAndHandler>();
            passwordHashAndHandlers.add(passwordHashAndHandler);
            this.tunnelParametersToPasswordHashAndHandlerMap.put(tunnelParameters, passwordHashAndHandlers);
        }
        TunnelParametersAndPasswordHash tunnelParametersAndPasswordHash = new TunnelParametersAndPasswordHash(tunnelParameters, passwordHashAndHandler.getPasswordHash());
        this.tunnelSessionToTunnelParametersAndPasswordHashMap.put(tunnelSessionProperties.getTunnelSessionId(), tunnelParametersAndPasswordHash);
        return tunnelSessionProperties;
    }

    public void closeAllDbTunnels() throws BackgroundTunnelManagerException {
        List<BackgroundTunnelHandler> backgroundTunnelHandlers = this.getAllBackgroundTunnelHandlers();
        for (BackgroundTunnelHandler backgroundTunnelHandler : backgroundTunnelHandlers) {
            backgroundTunnelHandler.closeDbTunnel();
        }
    }

    private List<BackgroundTunnelHandler> getAllBackgroundTunnelHandlers() {
        ArrayList<BackgroundTunnelHandler> backgroundTunnelHandlers = new ArrayList<BackgroundTunnelHandler>();
        Collection<List<PasswordHashAndHandler>> passwordHashAndHandlers = this.tunnelParametersToPasswordHashAndHandlerMap.values();
        for (List<PasswordHashAndHandler> passwordHashAndHandlerList : passwordHashAndHandlers) {
            for (PasswordHashAndHandler passwordHashAndHandler : passwordHashAndHandlerList) {
                backgroundTunnelHandlers.add(passwordHashAndHandler.getBackgroundTunnelHandler());
            }
        }
        return backgroundTunnelHandlers;
    }

    public BackgroundTunnelSessionCloseResult closeDbTunnelSession(String tunnelSessionId) throws BackgroundTunnelManagerException {
        TunnelParametersAndPasswordHash tunnelParametersAndPasswordHash = this.tunnelSessionToTunnelParametersAndPasswordHashMap.get(tunnelSessionId);
        if (tunnelParametersAndPasswordHash == null) {
            return BackgroundTunnelSessionCloseResult.TUNNEL_SESSION_NOT_FOUND;
        }
        PasswordHashAndHandler passwordHashAndHandler = this.getPasswordHashAndHandler(tunnelParametersAndPasswordHash.getTunnelParameters(), null, tunnelParametersAndPasswordHash.getPasswordHash());
        BackgroundTunnelHandler backgroundTunnelHandler = passwordHashAndHandler.getBackgroundTunnelHandler();
        if (backgroundTunnelHandler == null) {
            throw new BackgroundTunnelManagerException("BackgroundTunnelHandler not found for tunnelSessionId '" + tunnelSessionId + "' " + tunnelParametersAndPasswordHash.getTunnelParameters());
        }
        BackgroundTunnelSessionCloseResult backgroundTunnelSessionCloseResult = backgroundTunnelHandler.closeDbTunnelSession(tunnelSessionId);
        this.tunnelSessionToTunnelParametersAndPasswordHashMap.remove(tunnelSessionId);
        return backgroundTunnelSessionCloseResult;
    }

    protected PasswordHashAndHandler getPasswordHashAndHandler(TunnelParameters tunnelParameters, String password, String passwordHash) throws BackgroundTunnelManagerException {
        if (password == null == (passwordHash == null)) {
            throw new IllegalArgumentException("Only one of the parameters password and passwordHash must be set.");
        }
        PasswordHashAndHandler result = null;
        List<PasswordHashAndHandler> passwordHashAndHandlers = this.tunnelParametersToPasswordHashAndHandlerMap.get(tunnelParameters);
        if (passwordHashAndHandlers != null) {
            for (PasswordHashAndHandler passwordHashAndHandler : passwordHashAndHandlers) {
                String entryPasswordHash = passwordHashAndHandler.getPasswordHash();
                if ((passwordHash == null || !passwordHash.equals(entryPasswordHash)) && (password == null || !BackgroundTunnelStore.doesPasswordMatch(password, entryPasswordHash))) continue;
                result = passwordHashAndHandler;
                break;
            }
        }
        return result;
    }

    void unregisterBackgroundTunnelHandler(TunnelParameters tunnelParameters, Collection<String> tunnelSessionIds) {
        this.tunnelSessionToTunnelParametersAndPasswordHashMap.keySet().removeAll(tunnelSessionIds);
        this.tunnelParametersToPasswordHashAndHandlerMap.remove(tunnelParameters);
    }

    protected PasswordHashAndHandler createBackgroundTunnelHandler(TunnelParameters tunnelParameters, String password, BackgroundTunnelStateListener tunnelDownEventListener) throws BackgroundTunnelManagerException {
        BackgroundTunnelHandler backgroundTunnelHandler = new BackgroundTunnelHandler(tunnelParameters, tunnelDownEventListener);
        return new PasswordHashAndHandler(BackgroundTunnelStore.createPasswordHash(password), backgroundTunnelHandler);
    }

    public static String createPasswordHash(String password) throws BackgroundTunnelManagerException {
        try {
            return BackgroundTunnelPasswordHash.createPasswordHash(password);
        }
        catch (NoSuchAlgorithmException e) {
            throw new BackgroundTunnelManagerException("Cannot create password hash." + e);
        }
        catch (InvalidKeySpecException e) {
            throw new BackgroundTunnelManagerException("Cannot create password hash." + e);
        }
    }

    private static boolean doesPasswordMatch(String password, String existingHash) throws BackgroundTunnelManagerException {
        boolean passwordMatches;
        try {
            passwordMatches = BackgroundTunnelPasswordHash.validatePassword(password, existingHash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new BackgroundTunnelManagerException("Cannot validate password.", e);
        }
        catch (InvalidKeySpecException e) {
            throw new BackgroundTunnelManagerException("Cannot validate password.", e);
        }
        return passwordMatches;
    }

    static class TunnelParametersAndPasswordHash {
        private final TunnelParameters tunnelParameters;
        private final String passwordHash;

        TunnelParametersAndPasswordHash(TunnelParameters tunnelParameters, String passwordHash) {
            this.tunnelParameters = tunnelParameters;
            this.passwordHash = passwordHash;
        }

        TunnelParameters getTunnelParameters() {
            return this.tunnelParameters;
        }

        String getPasswordHash() {
            return this.passwordHash;
        }
    }

    public static class PasswordHashAndHandler {
        private final String passwordHash;
        private final BackgroundTunnelHandler backgroundTunnelHandler;

        public PasswordHashAndHandler(String passwordHash, BackgroundTunnelHandler backgroundTunnelHandler) {
            this.passwordHash = passwordHash;
            this.backgroundTunnelHandler = backgroundTunnelHandler;
        }

        public String getPasswordHash() {
            return this.passwordHash;
        }

        public BackgroundTunnelHandler getBackgroundTunnelHandler() {
            return this.backgroundTunnelHandler;
        }
    }
}

