/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.tunnel.connection;

import com.sap.core.connectivity.tunnel.api.management.ProxyProtocol;
import com.sap.core.persistence.commands.tunnel.connection.LocalMapping;
import com.sap.core.persistence.commands.tunnel.connection.LocalNetworkPortProvider;
import com.sap.core.persistence.commands.tunnel.connection.TunnelBackendInformationImpl;
import com.sap.core.persistence.commands.tunnel.entities.DbTunnelInformation;
import com.sap.core.persistence.commands.util.DBTypeConversion;
import java.io.IOException;

public class DBSpecificHelper {
    protected LocalNetworkPortProvider portProvider;
    protected final DbType dbType;

    DBSpecificHelper(DbType dbType) {
        this.dbType = dbType;
        this.portProvider = new LocalNetworkPortProvider();
    }

    public LocalMapping[] getLocalMappings(DbTunnelInformation.VirtualHost[] virtualHosts) throws IOException {
        LocalMapping[] result = new LocalMapping[virtualHosts.length];
        for (int i = 0; i < virtualHosts.length; ++i) {
            DbTunnelInformation.VirtualHost virtualHost = virtualHosts[i];
            result[i] = new LocalMapping(virtualHost.getVirtualHost(), virtualHost.getPort(), this.getProtocol(virtualHost));
        }
        this.remapIfRequired(result);
        return result;
    }

    protected void remapIfRequired(LocalMapping[] result) throws IOException {
        for (LocalMapping mapping : result) {
            if (this.portProvider.isFree(mapping.getPort())) continue;
            int freePort = this.portProvider.getFreePort();
            mapping.setPort(freePort);
        }
    }

    public void dumpInformationForUser(TunnelBackendInformationImpl result, LocalMapping[] localMapping) {
        result.setDbIdentifier(this.dbType.getName());
    }

    protected ProxyProtocol getProtocol(DbTunnelInformation.VirtualHost virtualHost) {
        return ProxyProtocol.JDBC;
    }

    public static enum DbType {
        maxdb,
        sybasease,
        ase,
        hana,
        hanaxs,
        hanamdc;


        public String getName() {
            return DBTypeConversion.getDisplayName(this.name());
        }
    }
}

