/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.tunnel.connection;

import com.sap.core.connectivity.spi.ConnectionProtocol;
import com.sap.core.connectivity.spi.ErrorHandler;
import com.sap.core.connectivity.spi.extension.ExtensionRegistry;
import com.sap.core.connectivity.tunnel.api.LookupException;
import com.sap.core.connectivity.tunnel.api.TunnelProvidedServices;
import com.sap.core.connectivity.tunnel.api.management.ConnectionFailedException;
import com.sap.core.connectivity.tunnel.api.management.DirectTunnelOperator;
import com.sap.core.connectivity.tunnel.api.management.PortUnavailableException;
import com.sap.core.connectivity.tunnel.api.management.ProxyManagement;
import com.sap.core.connectivity.tunnel.api.management.TunnelEndpoint;
import com.sap.core.connectivity.tunnel.api.management.TunnelManagement;
import com.sap.core.connectivity.tunnel.api.management.TunnelStateListener;
import com.sap.core.persistence.commands.tunnel.api.TunnelBackendInformation;
import com.sap.core.persistence.commands.tunnel.connection.DBSpecificHelper;
import com.sap.core.persistence.commands.tunnel.connection.HanaSpecificHelper;
import com.sap.core.persistence.commands.tunnel.connection.LocalMapping;
import com.sap.core.persistence.commands.tunnel.connection.LocalTunnelEndpoint;
import com.sap.core.persistence.commands.tunnel.connection.MaxDBSpecificHelper;
import com.sap.core.persistence.commands.tunnel.connection.SSLContextFactory;
import com.sap.core.persistence.commands.tunnel.connection.SybaseASESpecificHelper;
import com.sap.core.persistence.commands.tunnel.connection.TunnelBackendInformationImpl;
import com.sap.core.persistence.commands.tunnel.entities.DbTunnelInformation;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import io.netty.channel.Channel;
import java.io.IOException;
import java.util.UUID;
import org.apache.log4j.Logger;

public class DbTunnelManager {
    private Logger LOGGER = Logger.getLogger(DbTunnelManager.class);
    private final DbTunnelInformation tunnelInformation;
    private final TunnelEndpoint localEndpoint;
    private LocalMapping[] localMappings;
    private DBSpecificHelper helper;
    private DirectTunnelOperator tunnelOperator;
    private ProxyManagement proxyManagement;
    private MessageHandler messageHandler;
    private boolean isShutdown;
    private int requiredHanaInstance;
    private int[] blockedHanaInstances;

    public DbTunnelManager(DbTunnelInformation tunnelInformation, String host, int requiredHanaInstance, int[] blockedHanaInstances) throws IOException {
        this.tunnelInformation = tunnelInformation;
        this.localEndpoint = new LocalTunnelEndpoint(host, new SSLContextFactory(tunnelInformation.getCertificate()));
        this.requiredHanaInstance = requiredHanaInstance;
        this.blockedHanaInstances = blockedHanaInstances;
    }

    public void startTunnelClient() {
        if (this.tunnelOperator != null) {
            throw new IllegalStateException("Local tunnel already started.");
        }
        try {
            this.tunnelOperator = this.getDirectTunnelOperator(this.localEndpoint, UUID.randomUUID().toString());
        }
        catch (LookupException e) {
            throw new CommandException("Failed to start tunnel client", (Throwable)e, 211);
        }
        try {
            this.registerErrorHandler();
        }
        catch (LookupException e) {
            throw new CommandException("Failed to register error handler", (Throwable)e, 212);
        }
        try {
            this.tunnelOperator.connect(this.tunnelInformation.getTunnelId(), this.tunnelInformation.getRoutingInformation());
        }
        catch (ConnectionFailedException e) {
            throw new CommandException("Failed to connect the tunnel", (Throwable)e, 213);
        }
        this.proxyManagement = this.tunnelOperator.getProxyManagement();
        this.helper = this.getDBSpecificHelper();
        try {
            this.localMappings = this.helper.getLocalMappings(this.tunnelInformation.getVirtualHosts());
        }
        catch (IOException e) {
            throw new CommandException("Failed to find valid local port mapping", (Throwable)e, 214);
        }
        for (LocalMapping mapping : this.localMappings) {
            try {
                this.proxyManagement.startProxy(mapping.getPort(), this.tunnelInformation.getTunnelId(), mapping.getName(), mapping.getProtocol());
            }
            catch (PortUnavailableException e) {
                throw new CommandException("Failed to start proxy on local port " + mapping.getPort(), (Throwable)e);
            }
        }
        this.tunnelOperator.addListener(new TunnelStateListener(){

            public void tunnelClosed(String tunnelId) {
                DbTunnelManager.this.LOGGER.debug((Object)("TunnelStateListener received tunnelClosed for tunnel " + tunnelId));
                if (!DbTunnelManager.this.isShutdown) {
                    DbTunnelManager.this.fireMessage(101, "Connection to backend lost.");
                    DbTunnelManager.this.tunnelOperator = null;
                }
            }
        });
    }

    public TunnelBackendInformation getTunnelBackendInformation() {
        TunnelBackendInformationImpl result = new TunnelBackendInformationImpl();
        result.setUser(this.tunnelInformation.getUser());
        result.setPassword(this.tunnelInformation.getPassword());
        result.setInitialPasswordOnly(this.tunnelInformation.isUnmanagedServer() && this.tunnelInformation.getPassword() != null);
        if (this.tunnelInformation.isUnmanagedServer()) {
            result.setSchemaName(null);
        } else {
            result.setSchemaName(this.tunnelInformation.getSchemaName());
        }
        this.helper.dumpInformationForUser(result, this.localMappings);
        return result;
    }

    public synchronized void shutdown() {
        if (this.tunnelOperator != null) {
            this.isShutdown = true;
            if (this.proxyManagement != null) {
                this.proxyManagement.stopAllProxies();
            }
            this.tunnelOperator.disconnect();
            this.tunnelOperator = null;
        }
    }

    protected DirectTunnelOperator getDirectTunnelOperator(TunnelEndpoint localEndpoint, String clientId) throws LookupException {
        TunnelManagement tunnelManagement = (TunnelManagement)TunnelProvidedServices.getService(TunnelManagement.class);
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)String.format("Creating direct tunnel operator for client with ID %s and server address %s", clientId, localEndpoint.getTunnelServerAddress()));
            if (localEndpoint.getHttpsProxy() != null) {
                this.LOGGER.debug((Object)("Using proxy " + localEndpoint.getHttpsProxy().getAddress()));
            }
        }
        return tunnelManagement.createDirectTunnelOperator(localEndpoint, clientId);
    }

    protected void registerErrorHandler() throws LookupException {
        ExtensionRegistry extensionRegistry = (ExtensionRegistry)TunnelProvidedServices.getService(ExtensionRegistry.class);
        extensionRegistry.registerErrorHandler(ConnectionProtocol.JDBC, new ErrorHandler(){

            public void handleError(Channel channel, int code, String message) {
                switch (code) {
                    case 100: {
                        DbTunnelManager.this.LOGGER.warn((Object)"Tunnel reported an internal error, state of tunnel not clear");
                        break;
                    }
                    case 101: {
                        if (DbTunnelManager.this.tunnelOperator != null) {
                            DbTunnelManager.this.tunnelOperator.disconnect();
                            DbTunnelManager.this.tunnelOperator = null;
                        }
                        DbTunnelManager.this.fireMessage(101, "Connection to backend lost. " + message);
                        break;
                    }
                    case 1000: {
                        DbTunnelManager.this.fireMessage(102, message);
                        break;
                    }
                    default: {
                        DbTunnelManager.this.LOGGER.warn((Object)("Received unexpected error code " + code + " from tunnel"));
                    }
                }
            }
        });
    }

    private void fireMessage(int statusCode, String message) {
        if (this.messageHandler != null) {
            this.messageHandler.fireMessage(statusCode, message);
        }
    }

    public void setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public DBSpecificHelper getDBSpecificHelper() {
        DBSpecificHelper.DbType dbType = DBSpecificHelper.DbType.valueOf(this.tunnelInformation.getDbIdentifier());
        switch (dbType) {
            case hana: 
            case hanaxs: 
            case hanamdc: {
                return new HanaSpecificHelper(dbType, this.tunnelInformation, this.requiredHanaInstance, this.blockedHanaInstances);
            }
            case maxdb: {
                return new MaxDBSpecificHelper(this.tunnelInformation);
            }
            case sybasease: 
            case ase: {
                return new SybaseASESpecificHelper(dbType, this.tunnelInformation);
            }
        }
        return new DBSpecificHelper(dbType);
    }

    public static interface MessageHandler {
        public void fireMessage(int var1, String var2);
    }
}

