/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.tunnel.connection;

import com.sap.core.connectivity.tunnel.api.management.ProxyProtocol;
import com.sap.core.persistence.commands.tunnel.api.PortsInUseException;
import com.sap.core.persistence.commands.tunnel.connection.DBSpecificHelper;
import com.sap.core.persistence.commands.tunnel.connection.LocalMapping;
import com.sap.core.persistence.commands.tunnel.connection.TunnelBackendInformationImpl;
import com.sap.core.persistence.commands.tunnel.entities.DbTunnelInformation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class HanaSpecificHelper
extends DBSpecificHelper {
    private DbTunnelInformation tunnelInformation;
    private int requiredInstance;
    private Set<Integer> blockedInstances = new HashSet<Integer>();

    HanaSpecificHelper(DBSpecificHelper.DbType type, DbTunnelInformation tunnelInformation, int requiredInstance, int[] blockedInstances) {
        super(type);
        this.tunnelInformation = tunnelInformation;
        this.requiredInstance = requiredInstance;
        if (blockedInstances != null) {
            for (int blockedInstance : blockedInstances) {
                this.blockedInstances.add(blockedInstance);
            }
        }
        if (requiredInstance != -1 && this.blockedInstances.contains(requiredInstance)) {
            throw new IllegalArgumentException("Required instance cannot be part of blocked instances.");
        }
    }

    @Override
    public void dumpInformationForUser(TunnelBackendInformationImpl result, LocalMapping[] localMapping) {
        result.setDbIdentifier(this.dbType.getName());
        int port = this.getJDBCPort(localMapping);
        result.setJdbcPort(port);
        String jdbcURL = this.getJDBCUrl(port);
        result.setJdbcUrl(jdbcURL);
        result.setInstanceId(Integer.toString(port).substring(1, 3));
    }

    private int getJDBCPort(LocalMapping[] localMapping) {
        for (LocalMapping mapping : localMapping) {
            int port = mapping.getPort();
            if (!this.isJDBCPort(port)) continue;
            return port;
        }
        return -1;
    }

    private String getJDBCUrl(int port) {
        String jdbcURL = "jdbc:sap://localhost:" + port + "/";
        if (this.tunnelInformation != null) {
            String schemaName = this.tunnelInformation.getSchemaName();
            if (!this.tunnelInformation.isUnmanagedServer() && schemaName != null && !schemaName.equals(this.tunnelInformation.getUser())) {
                jdbcURL = jdbcURL + "?currentschema=" + schemaName;
            }
        }
        return jdbcURL;
    }

    @Override
    protected void remapIfRequired(LocalMapping[] localMappings) throws IOException {
        if (this.requiredInstance >= 0) {
            this.remap(localMappings, this.requiredInstance);
            List<Integer> busyPorts = this.getPortsInUse(localMappings);
            if (!busyPorts.isEmpty()) {
                throw new PortsInUseException("Ports for required instance number '" + this.requiredInstance + "' are already in use.", busyPorts);
            }
        } else {
            if (!this.isBlocked(localMappings) && this.getPortsInUse(localMappings).isEmpty()) {
                return;
            }
            for (int instanceId = 0; instanceId < 100; ++instanceId) {
                if (this.blockedInstances.contains(instanceId)) continue;
                this.remap(localMappings, instanceId);
                if (!this.getPortsInUse(localMappings).isEmpty()) continue;
                return;
            }
            throw new IOException("Failed to find free local ports");
        }
    }

    private boolean isBlocked(LocalMapping[] localMappings) {
        for (LocalMapping localMapping : localMappings) {
            if (!this.blockedInstances.contains(localMapping.getPort() / 100 % 100)) continue;
            return true;
        }
        return false;
    }

    private void remap(LocalMapping[] localMappings, int id) {
        for (LocalMapping mapping : localMappings) {
            int port = mapping.getPort();
            int newPort = 10000 * (port / 10000) + 100 * id + port % 100;
            mapping.setPort(newPort);
        }
    }

    private List<Integer> getPortsInUse(LocalMapping[] localMappings) {
        ArrayList<Integer> portsInUse = new ArrayList<Integer>();
        for (LocalMapping localMapping : localMappings) {
            if (this.portProvider.isFree(localMapping.getPort())) continue;
            portsInUse.add(localMapping.getPort());
        }
        return portsInUse;
    }

    @Override
    protected ProxyProtocol getProtocol(DbTunnelInformation.VirtualHost virtualHost) {
        ProxyProtocol protocol = this.isJDBCPort(virtualHost.getPort()) ? ProxyProtocol.JDBC : ProxyProtocol.TCP;
        return protocol;
    }

    private boolean isJDBCPort(int port) {
        return port < 40000;
    }
}

