/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.tunnel.connection;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;

class LocalNetworkPortProvider {
    LocalNetworkPortProvider() {
    }

    public int getFreePort() throws IOException {
        ServerSocket ss = new ServerSocket(0);
        int port = ss.getLocalPort();
        ss.close();
        while (!this.isFree(port)) {
            if (++port <= 65535) continue;
            port = 1024;
        }
        return port;
    }

    public boolean isFree(int port) {
        if (port == 0) {
            return false;
        }
        try {
            ServerSocket ss = new ServerSocket(port);
            ss.close();
            return !this.canConnect(port);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private boolean canConnect(int port) throws UnknownHostException {
        InetAddress[] allByName;
        if (this.canConnect(InetAddress.getLocalHost(), port)) {
            return true;
        }
        for (InetAddress inetAddress : allByName = InetAddress.getAllByName(null)) {
            if (!this.canConnect(inetAddress, port)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canConnect(InetAddress address, int port) {
        Socket s = null;
        try {
            s = new Socket(address, port);
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }
}

