/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.tunnel.connection;

import com.sap.core.connectivity.tunnel.api.management.HTTPSProxy;
import com.sap.core.connectivity.tunnel.api.management.TunnelEndpoint;
import com.sap.core.persistence.commands.tunnel.connection.SSLContextFactory;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;

class LocalTunnelEndpoint
implements TunnelEndpoint {
    private static final String CONNECTIVITY_TUNNEL_ENDPOINT_PREFIX = "connectivitytunnel.";
    private static final int CONNECTIVITY_TUNNEL_ENDPOINT_PORT = 443;
    private static final String PROPERTY_KEY_HTTPS_PROXY_HOST = "https.proxyHost";
    private static final String PROPERTY_KEY_HTTPS_PROXY_PORT = "https.proxyPort";
    private static final String PROPERTY_KEY_HTTPS_PROXY_USER = "https.proxyUser";
    private static final String PROPERTY_KEY_HTTPS_PROXY_PASSWORD = "https.proxyPassword";
    private String host;
    private final SSLContextFactory sslContextFactory;

    public LocalTunnelEndpoint(String tunnelServerHost, SSLContextFactory sslContextFactory) {
        this.host = tunnelServerHost;
        this.sslContextFactory = sslContextFactory;
    }

    public InetSocketAddress getNotificationAddress() {
        return null;
    }

    public InetSocketAddress getTunnelServerAddress() {
        URI uri;
        try {
            uri = new URI(this.host);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid host URI", e);
        }
        String endpointHostName = CONNECTIVITY_TUNNEL_ENDPOINT_PREFIX + this.getLandscapeUrl(uri);
        return new InetSocketAddress(endpointHostName, 443);
    }

    private String getLandscapeUrl(URI uri) {
        int hostnameSeparatorIndex;
        String landscapeUrl = uri.getHost();
        if (landscapeUrl.startsWith("services") && (hostnameSeparatorIndex = landscapeUrl.indexOf(46)) > 0) {
            landscapeUrl = landscapeUrl.substring(hostnameSeparatorIndex + 1);
        }
        return landscapeUrl;
    }

    public HTTPSProxy getHttpsProxy() {
        final String proxyHost = System.getProperty(PROPERTY_KEY_HTTPS_PROXY_HOST);
        if (proxyHost == null) {
            return null;
        }
        return new HTTPSProxy(){

            public String getUser() {
                return System.getProperty(LocalTunnelEndpoint.PROPERTY_KEY_HTTPS_PROXY_USER);
            }

            public String getPassword() {
                return System.getProperty(LocalTunnelEndpoint.PROPERTY_KEY_HTTPS_PROXY_PASSWORD);
            }

            public InetSocketAddress getAddress() {
                String proxyPortString = System.getProperty(LocalTunnelEndpoint.PROPERTY_KEY_HTTPS_PROXY_PORT);
                if (proxyPortString == null || proxyPortString.length() == 0) {
                    proxyPortString = "80";
                }
                try {
                    int proxyPort = Integer.parseInt(proxyPortString);
                    return new InetSocketAddress(proxyHost, proxyPort);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("The proxy port could not be determined, ensure that the environment variable 'https.proxyPort' is a number, current value is '" + proxyPortString + "'.");
                }
            }
        };
    }

    public SSLContext getSSLContext() throws GeneralSecurityException {
        return this.sslContextFactory.getContext();
    }

    public HTTPSProxy getTunnelServerHttpsProxy() {
        return this.getHttpsProxy();
    }
}

