/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.tunnel.connection;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

class PEMDecoder {
    private static final Logger log = Logger.getLogger(PEMDecoder.class);
    private final String pemData;

    PEMDecoder(String pemData) {
        this.pemData = pemData == null ? "" : pemData;
    }

    public PrivateKey getPrivateKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] bytes = this.getBytes(this.pemData, "RSA PRIVATE KEY");
        if (bytes != null) {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(keySpec);
        }
        return null;
    }

    public X509Certificate getCertificate() throws CertificateException {
        byte[] bytes = this.getBytes(this.pemData, "CERTIFICATE");
        if (bytes != null) {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            return (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(bytes));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBytes(String pemFormat, String type) {
        String beginHeader = "-----BEGIN " + type + "-----";
        String endHeader = "-----END " + type + "-----";
        BufferedReader br = new BufferedReader(new StringReader(pemFormat));
        boolean inContent = false;
        StringBuilder content = new StringBuilder();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                line = line.trim();
                if (inContent) {
                    if (endHeader.equals(line)) {
                        byte[] byArray = Base64.decodeBase64((byte[])content.toString().getBytes("ASCII"));
                        return byArray;
                    }
                    content.append(line);
                    continue;
                }
                if (!beginHeader.equals(line)) continue;
                inContent = true;
            }
        }
        catch (IOException ex) {
            log.debug((Object)"Memory operation caused an IOException", (Throwable)ex);
        }
        finally {
            IOUtils.closeQuietly((Reader)br);
        }
        return null;
    }
}

