/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.tunnel.connection;

import com.sap.core.persistence.commands.tunnel.connection.PEMDecoder;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.UUID;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;

class SSLContextFactory {
    private SSLContext clientContext;
    private static final char[] KEYSTORE_PASS = UUID.randomUUID().toString().toCharArray();
    private PrivateKey privateKey;
    private X509Certificate certificate;

    public SSLContextFactory(String pemData) throws IOException {
        PEMDecoder decoder = new PEMDecoder(pemData);
        try {
            this.privateKey = decoder.getPrivateKey();
            this.certificate = decoder.getCertificate();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Failed to set up SSLContextFactory", e);
        }
        catch (InvalidKeySpecException e) {
            throw new IOException("Failed to set up SSLContextFactory", e);
        }
        catch (CertificateException e) {
            throw new IOException("Failed to set up SSLContextFactory", e);
        }
    }

    public synchronized SSLContext getContext() throws GeneralSecurityException {
        if (this.clientContext == null) {
            this.initializeClientContext();
        }
        return this.clientContext;
    }

    private void initializeClientContext() throws GeneralSecurityException {
        KeyStore ks = KeyStore.getInstance("JKS");
        try {
            ks.load(null, KEYSTORE_PASS);
        }
        catch (IOException e) {
            throw new GeneralSecurityException("Failed to set up key store", e);
        }
        ks.setKeyEntry("vm_cert", this.privateKey, KEYSTORE_PASS, new Certificate[]{this.certificate});
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(ks, KEYSTORE_PASS);
        this.clientContext = SSLContext.getInstance("TLS");
        this.clientContext.init(kmf.getKeyManagers(), null, null);
    }
}

