/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.admin.server.password.cmd.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import org.xml.sax.SAXException;

public class JSONParser {
    public static JsonObject parseJsonResponse(String body) throws SAXException {
        try {
            JsonElement result = JSONParser.parseStringToJson(body);
            if (result.isJsonObject()) {
                return result.getAsJsonObject();
            }
            throw new SAXException("Unexpected Json String: '" + body + "'");
        }
        catch (JsonParseException e) {
            throw new SAXException("The specified input is not valid JSON: '" + body + "'", e);
        }
    }

    public static JsonElement parseStringToJson(String json) {
        JsonParser parser = new JsonParser();
        JsonElement result = parser.parse(json);
        return result;
    }

    public static String getStringValue(JsonObject jsonObject, String key) {
        JsonElement jsonElement = jsonObject.get(key);
        if (jsonElement != null) {
            return jsonElement.getAsString();
        }
        return null;
    }

    public static Integer getIntegerValue(JsonObject jsonObject, String key) {
        JsonElement jsonElement = jsonObject.get(key);
        if (jsonElement != null) {
            return jsonElement.getAsInt();
        }
        return null;
    }

    public static Boolean getBooleanValue(JsonObject jsonObject, String key) {
        JsonElement jsonElement = jsonObject.get(key);
        if (jsonElement != null) {
            return jsonElement.getAsBoolean();
        }
        return null;
    }
}

