/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.admin.server.password.cmd.client;

import com.google.gson.Gson;
import com.sap.core.admin.server.password.cmd.client.HttpClientFactory;
import com.sap.core.admin.server.password.cmd.client.HttpClientFactoryException;
import com.sap.core.admin.server.password.cmd.client.OrchestratorClient;
import com.sap.core.admin.server.password.cmd.client.OrchestratorResult;
import com.sap.core.admin.server.password.cmd.client.Password;
import com.sap.core.admin.server.password.cmd.client.ResultBuilder;
import com.sap.core.utils.infrastructure.validation.LandscapeHostValidator;
import com.sap.core.utils.infrastructure.validation.ValidationStatus;
import java.io.IOException;
import java.net.URI;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.http.params.HttpParams;
import org.apache.log4j.Logger;

public class OrchestratorClientImpl
implements OrchestratorClient {
    private static final String SPACES = "spaces";
    private static final String APPLIANCES = "appliances";
    private static final String TENANTS = "tenants";
    private static final String OPERATION_SET_PASSWORD = "set-password";
    private static final String OPERATION_LIST_PASSWORD = "list-password";
    private static final String HTTPS_SCHEMA = "https://";
    private static final String HTTP_SCHEMA = "http://";
    private static final String LOCALHOST_BY_IP = "http://127.0.0.1";
    private static final String LOCALHOST_BY_NAME = "http://localhost";
    private static final String DEPLOYMENT_SUBDOMAIN = "https://deployment.";
    private static final String ORCHESTRATOR_SUBDOMAIN = "https://orchestrator.";
    private static final Logger LOGGER = Logger.getLogger(OrchestratorClientImpl.class);
    private static final int SOCKET_TIMEOUT = 600000;
    private static final String PASSWORD_ALIAS = "password";
    private String account;
    private final HttpClient httpClient;

    public OrchestratorClientImpl(String account, HttpClient httpClient) {
        this.account = account;
        this.httpClient = httpClient;
    }

    public static OrchestratorClient getOrchestratorClient(String account, HttpClient httpClient) {
        return new OrchestratorClientImpl(account, httpClient);
    }

    @Override
    public OrchestratorResult setPassword(String application, String tenant, String passwordName, String passwordValue, String host) throws HttpClientFactoryException, IOException {
        HttpClient client = this.getClient();
        host = OrchestratorClientImpl.prepareAndValidateHostString(host, PASSWORD_ALIAS);
        return this.doSetPassword(this.account, application, tenant, passwordName, passwordValue, host, client);
    }

    @Override
    public OrchestratorResult listPasssword(String application, String tenant, String host) throws HttpClientFactoryException, IOException {
        HttpClient client = this.getClient();
        host = OrchestratorClientImpl.prepareAndValidateHostString(host, PASSWORD_ALIAS);
        return this.doListPassword(this.account, application, tenant, host, client);
    }

    @Override
    public OrchestratorResult deletePassword(String application, String tenant, String passwordName, String host) throws HttpClientFactoryException, IOException {
        HttpClient client = this.getClient();
        host = OrchestratorClientImpl.prepareAndValidateHostString(host, PASSWORD_ALIAS);
        return this.doDeletePassword(this.account, application, tenant, passwordName, host, client);
    }

    private OrchestratorResult doSetPassword(String account, String application, String tenant, String passwordName, String passwordValue, String host, HttpClient client) throws IOException {
        if (application == null) {
            throw new IllegalArgumentException("Application name must not be null.");
        }
        if (host.endsWith("/")) {
            host = host.substring(0, host.length() - 1);
        }
        StringBuilder startRequest = new StringBuilder(host + "/domain_basic/" + PASSWORD_ALIAS + "/" + SPACES + "/" + account + "/" + APPLIANCES + "/" + application + "/" + TENANTS + "/" + tenant);
        Password password = new Password();
        password.setName(passwordName);
        password.setValue(passwordValue);
        Gson gson = new Gson();
        HttpPut setPasswordHttpPutRequest = new HttpPut(startRequest.toString());
        StringEntity entity = new StringEntity(gson.toJson(password), "application/json", "utf-8");
        setPasswordHttpPutRequest.setEntity(entity);
        HttpResponse setPasswordResponse = OrchestratorClientImpl.executeRequestAndFollowRedirect(client, setPasswordHttpPutRequest);
        String restRequest = setPasswordHttpPutRequest.getRequestLine().toString();
        return ResultBuilder.buildLifecycleResult(setPasswordResponse, OPERATION_SET_PASSWORD, restRequest, host);
    }

    private OrchestratorResult doListPassword(String account, String application, String tenant, String host, HttpClient client) throws IOException {
        if (application == null) {
            throw new IllegalArgumentException("Application name must not be null.");
        }
        if (host.endsWith("/")) {
            host = host.substring(0, host.length() - 1);
        }
        StringBuilder startRequest = new StringBuilder(host + "/domain_basic/" + PASSWORD_ALIAS + "/" + SPACES + "/" + account + "/" + APPLIANCES + "/" + application + "/" + TENANTS + "/" + tenant);
        HttpGet listPasswordHttpGetRequest = new HttpGet(startRequest.toString());
        HttpResponse listPasswordResponse = OrchestratorClientImpl.executeRequestAndFollowRedirect(client, listPasswordHttpGetRequest);
        String restRequest = listPasswordHttpGetRequest.getRequestLine().toString();
        return ResultBuilder.buildLifecycleResult(listPasswordResponse, OPERATION_LIST_PASSWORD, restRequest, host);
    }

    private OrchestratorResult doDeletePassword(String account, String application, String tenant, String passwordName, String host, HttpClient client) throws IOException {
        if (application == null) {
            throw new IllegalArgumentException("Application name must not be null.");
        }
        if (host.endsWith("/")) {
            host = host.substring(0, host.length() - 1);
        }
        StringBuilder deleteRequest = new StringBuilder(host + "/domain_basic/" + PASSWORD_ALIAS + "/" + SPACES + "/" + account + "/" + APPLIANCES + "/" + application + "/" + TENANTS + "/" + tenant + "/" + passwordName);
        HttpDelete deletePasswordRequest = new HttpDelete(deleteRequest.toString());
        HttpResponse deletePasswordResponse = OrchestratorClientImpl.executeRequestAndFollowRedirect(client, deletePasswordRequest);
        String restRequest = deletePasswordRequest.getRequestLine().toString();
        return ResultBuilder.buildLifecycleResult(deletePasswordResponse, OPERATION_LIST_PASSWORD, restRequest, host);
    }

    private HttpClient getClient() throws HttpClientFactoryException {
        HttpClient client;
        if (this.httpClient != null) {
            client = this.httpClient;
        } else {
            client = HttpClientFactory.createSSLHttpClient();
            this.setSocketTimeout(client);
        }
        return client;
    }

    private void setSocketTimeout(HttpClient httpClient) {
        if (httpClient != null) {
            HttpParams params = httpClient.getParams();
            Integer timeout = params.getIntParameter("http.socket.timeout", 600000);
            if (timeout == 0) {
                timeout = 600000;
            }
            params.setIntParameter("http.socket.timeout", timeout);
        }
    }

    private static HttpResponse executeRequestAndFollowRedirect(HttpClient httpClient, HttpRequestBase httpRequest) throws IOException {
        HttpResponse response = httpClient.execute(httpRequest);
        int status = response.getStatusLine().getStatusCode();
        if (status == 302) {
            Header locationHeader;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Http request to URI [" + httpRequest.getURI() + "] requires redirect. The status code is " + status);
            }
            if ((locationHeader = response.getFirstHeader("Location")) != null) {
                String redirectLocation = locationHeader.getValue();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("The redirect location is [" + redirectLocation + "]");
                }
                httpRequest.setURI(URI.create(redirectLocation));
                return httpClient.execute(httpRequest);
            }
            throw new ClientProtocolException("Http request to URL [" + httpRequest.getURI() + "] requires redirect, but the response doesn`t specify URL for redirection");
        }
        return response;
    }

    private static String prepareAndValidateHostString(String host, String alias) throws IOException {
        if (host == null) {
            throw new IllegalArgumentException("Host must not be null");
        }
        if (host.endsWith("/")) {
            host = host.substring(0, host.length() - 1);
        }
        host = host.toLowerCase(Locale.ENGLISH);
        host = host.replace(DEPLOYMENT_SUBDOMAIN, HTTPS_SCHEMA);
        host = host.replace(ORCHESTRATOR_SUBDOMAIN, HTTPS_SCHEMA);
        OrchestratorClientImpl.checkHostValidity(host, "/");
        return host.replace(HTTPS_SCHEMA, DEPLOYMENT_SUBDOMAIN);
    }

    private static void checkHostValidity(String host, String alias) throws IOException {
        ValidationStatus status;
        if (host.equals(LOCALHOST_BY_IP) || host.equals(LOCALHOST_BY_NAME)) {
            return;
        }
        if (!alias.startsWith("/")) {
            alias = "/" + alias;
        }
        if ((status = LandscapeHostValidator.isLandscapeHostValid(host, alias, 600000, false)).isError()) {
            LOGGER.error("Host [" + host + "] and alias [" + alias + "] cannot be reached. Original error message is: " + status.getMessage(), status.getException());
            throw new IOException("Cannot reach host [" + host + "]. Check host name for typing errors and make sure your proxy and network settings are correct", status.getException());
        }
    }
}

