/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.admin.server.password.cmd.client;

import com.sap.core.admin.server.password.cmd.client.OrchestratorResult;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.util.Date;
import org.apache.log4j.Logger;

public class OrchestratorDumpHelper {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    static final String OFFSET = "  ";
    static final String SEP = "   ";
    private static final String FINISHED_WITH_ERROR = " finished with error";
    private static final String FINISHED_SUCCESSFULLY = " finished successfully";
    private static final String DATE_STRING = "%n[%s] ";
    public static Logger LOGGER = Logger.getLogger(OrchestratorDumpHelper.class);

    public static void printAndCheckOrchestratorResult(String operationName, OrchestratorResult lifecycleResult, int exitCode, boolean ignoreFailure) {
        String resultMessage = lifecycleResult.getMessage();
        String stackTrace = lifecycleResult.getStackTrace();
        if (lifecycleResult.getCode() == 0) {
            OrchestratorDumpHelper.dumpWithDateNewLine(operationName + " performed successfully.");
            OrchestratorDumpHelper.dump("");
        } else {
            OrchestratorDumpHelper.dumpWithDateNewLine(operationName + FINISHED_WITH_ERROR);
            OrchestratorDumpHelper.dump("");
        }
        OrchestratorDumpHelper.logStackTrace(operationName, resultMessage, stackTrace);
        StringBuilder message = new StringBuilder();
        OrchestratorDumpHelper.addResultMessage(message, resultMessage);
        OrchestratorDumpHelper.produceException(lifecycleResult, exitCode, ignoreFailure, stackTrace, message);
        OrchestratorDumpHelper.dump(message.toString());
    }

    public static void dumpWithDateNewLine(CharSequence message) {
        if (message == null || message.length() == 0) {
            return;
        }
        OrchestratorDumpHelper.dump(String.format(DATE_STRING + message, new Date()));
    }

    public static void dumpWithDateNewLine(CharSequence message, Date date) {
        if (message == null || message.length() == 0) {
            return;
        }
        OrchestratorDumpHelper.dump(String.format(DATE_STRING + message, date));
    }

    private static void logStackTrace(String operationName, String resultMessage, String stackTrace) {
        if (OrchestratorDumpHelper.isStackTracePresent(stackTrace)) {
            if (resultMessage != null && !resultMessage.isEmpty()) {
                LOGGER.warn(operationName + " failed with [" + resultMessage + "]: " + stackTrace);
            } else {
                LOGGER.warn(operationName + " failed with: " + stackTrace);
            }
        }
    }

    private static void addResultMessage(StringBuilder result, String message) {
        if (message != null && !message.isEmpty()) {
            OrchestratorDumpHelper.appendWithNewLine(result, message);
        }
    }

    private static void appendWithNewLine(StringBuilder result, String message) {
        result.append(message).append(LINE_SEPARATOR);
    }

    private static void produceException(OrchestratorResult result, int exitCode, boolean ignoreFailure, String stackTrace, CharSequence message) {
        if (!ignoreFailure && !OrchestratorDumpHelper.isResultOK(result)) {
            throw new CommandException(message.toString(), exitCode);
        }
    }

    public static boolean isResultOK(OrchestratorResult result) {
        return result != null && result.getCode() == 0;
    }

    public static boolean isStackTracePresent(String stackTrace) {
        return stackTrace != null && !stackTrace.isEmpty() && !stackTrace.equals("[]");
    }

    private static void dump(String message) {
        System.out.println(message);
    }
}

