/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.admin.server.password.cmd.client;

import com.sap.core.admin.server.password.cmd.client.Password;
import java.util.ArrayList;
import java.util.List;

public class OrchestratorResult {
    public static final int RESULT_OK = 0;
    public static final int RESULT_ERROR = 1;
    public static final int RESULT_INVALID_PARAMS = 2;
    public static final int RESULT_SERVER_ERROR = 3;
    public static final int RESULT_SET_PASSWORD_ERROR = 4;
    public static final int RESULT_LIST_PASSWORD_ERROR = 5;
    private int code;
    private String message;
    private String stackTrace;
    private List<Password> passwords;

    public OrchestratorResult() {
    }

    public OrchestratorResult(int code, String message, String stackTrace) {
        this.code = code;
        this.message = message;
        this.stackTrace = stackTrace;
        this.passwords = new ArrayList<Password>();
    }

    public OrchestratorResult(int code, String message, String stackTrace, List<Password> passwords) {
        this.code = code;
        this.message = message;
        this.stackTrace = stackTrace;
        this.passwords = passwords;
    }

    public OrchestratorResult(int code, String message) {
        this(code, message, null);
    }

    public OrchestratorResult(int code) {
        this(code, null, null);
    }

    public OrchestratorResult(Throwable t) {
        StackTraceElement[] elements = t.getStackTrace();
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement element : elements) {
            sb.append(element.toString());
            sb.append("\n");
        }
        this.code = 1;
        this.message = t.getMessage();
        this.stackTrace = sb.toString();
        this.passwords = null;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public List<Password> getPasswords() {
        return this.passwords;
    }

    public void setPasswords(List<Password> passwords) {
        this.passwords = passwords;
    }

    public String toString() {
        return "code=[" + this.code + "], " + ", message=[" + this.message + "]";
    }
}

