/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.admin.server.password.cmd.client;

import com.google.gson.Gson;
import com.sap.core.admin.server.password.cmd.client.OrchestratorResult;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class ResultBuilder {
    private static final Logger LOGGER = Logger.getLogger(ResultBuilder.class);
    public static final String AUTHENTICATION_EXCEPTION = "Authentication error. Check if you have provided correct credentials.";
    public static final String FORBIDDEN_EXCEPTION = "Access to %s is not allowed from your network. Contact SAP Cloud Platform for help";
    public static final String INVALID_USER_MSG = "Authentication failed. Check:\n1. if the subaccount name and the host are correct\n2. the provided user has rights to perform the operation in the specified subaccount\n3. the provided password is correct";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OrchestratorResult buildLifecycleResult(HttpResponse response, String operationName, String restRequest, String host) {
        int status = response.getStatusLine().getStatusCode();
        String message = null;
        HttpEntity entity = response.getEntity();
        try {
            if (entity != null) {
                message = EntityUtils.toString(entity);
            }
        }
        catch (IOException e) {
            String errorMsg = "Building of result for operation " + operationName + " failed.";
            LOGGER.error(errorMsg, e);
            OrchestratorResult orchestratorResult = ResultBuilder.buildLifecycleResult(1, errorMsg);
            return orchestratorResult;
        }
        finally {
            ResultBuilder.consumeEntity(entity);
        }
        switch (status) {
            case 200: {
                return ResultBuilder.buildLifecycleResult(0, message);
            }
            case 202: {
                return ResultBuilder.buildLifecycleResult(0, message);
            }
            case 404: {
                return ResultBuilder.buildLifecycleResult(5, message);
            }
            case 400: {
                return ResultBuilder.buildLifecycleResult(2, message);
            }
            case 500: {
                return new OrchestratorResult(3, "Internal server error: " + status);
            }
            case 403: {
                return ResultBuilder.buildLifecycleResult(3, message);
            }
            case 405: {
                return new OrchestratorResult(3, AUTHENTICATION_EXCEPTION);
            }
            case 401: {
                return new OrchestratorResult(3, INVALID_USER_MSG);
            }
        }
        return ResultBuilder.buildLifecycleResult(3, message);
    }

    public static OrchestratorResult buildLifecycleResult(int code, String jsonString) {
        if (jsonString == null || "".equals(jsonString.trim()) || jsonString.trim().equals("\"\"")) {
            return new OrchestratorResult(code, "There is no message in the response returned from server.");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("The body returned from the server is in json format: \n" + jsonString);
        }
        Gson gson = new Gson();
        OrchestratorResult orchestratorResult = gson.fromJson(jsonString, OrchestratorResult.class);
        orchestratorResult.setCode(code);
        return orchestratorResult;
    }

    private static boolean consumeEntity(HttpEntity entity) {
        try {
            if (entity != null) {
                EntityUtils.consume(entity);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Cannot consume entity ", e);
            return false;
        }
        return true;
    }
}

