/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.admin.server.password.cmd.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.admin.server.password.cmd.client.OrchestratorClient;
import com.sap.core.admin.server.password.cmd.client.OrchestratorClientImpl;
import com.sap.core.admin.server.password.cmd.client.OrchestratorDumpHelper;
import com.sap.core.admin.server.password.cmd.client.OrchestratorResult;
import com.sap.core.admin.server.password.cmd.commands.OrchestratorRemoteCommand;
import com.sap.core.admin.server.password.cmd.util.ConsoleUtil;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.util.ArrayList;
import java.util.Collections;

@Parameters(commandDescription="Deletes a password from password storage")
public class DeletePasswordCommand
extends OrchestratorRemoteCommand {
    @Parameter(names={"-b", "-application", "--application"}, description="Name of the application you want to manage, configure, or deploy")
    String application;
    @Parameter(names={"-t", "-tenant", "--tenant"}, description="Tenant-isolated application process for the given tenant", hidden=true)
    String tenant;
    @Parameter(names={"--alias"}, description="Identifies which password you want to delete")
    String passwordName;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() throws CommandException {
        if (this.tenant == null || this.tenant.equals("")) {
            this.tenant = "NULL";
        }
        if (!ConsoleUtil.checkArgSpecified("-a", "--account", this.account) || !ConsoleUtil.checkArgSpecified("-b", "--application", this.application) || !ConsoleUtil.checkArgSpecified(null, "--alias", this.passwordName)) throw new CommandException("Invalid parameters", 109);
        this.dumpParameters("delete-password", this.application, this.passwordName);
        try {
            OrchestratorClient client = OrchestratorClientImpl.getOrchestratorClient(this.account, this.httpClient);
            OrchestratorResult orchestratorResult = client.deletePassword(this.application, this.tenant, this.passwordName, this.host);
            OrchestratorDumpHelper.printAndCheckOrchestratorResult("delete-password", orchestratorResult, 125, false);
            if (orchestratorResult.getCode() != 0) return;
            System.out.println("Password deleted");
            return;
        }
        catch (Exception e) {
            throw new CommandException("delete-password failed", e, 121);
        }
    }

    public void dumpParameters(String operation, String application, String passwordName) {
        ArrayList argsList = new ArrayList();
        Collections.addAll(argsList, "subaccount", this.account, "application", application, "host", this.host, "alias", passwordName);
        DumpHelper.dumpOperationList(this.user, "Requesting " + operation + " for:", argsList.toArray());
    }

    @Override
    public String getName() {
        return "delete-password";
    }
}

