/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.admin.server.password.cmd.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.admin.server.password.cmd.client.OrchestratorClient;
import com.sap.core.admin.server.password.cmd.client.OrchestratorClientImpl;
import com.sap.core.admin.server.password.cmd.client.OrchestratorDumpHelper;
import com.sap.core.admin.server.password.cmd.client.OrchestratorResult;
import com.sap.core.admin.server.password.cmd.client.Password;
import com.sap.core.admin.server.password.cmd.commands.OrchestratorRemoteCommand;
import com.sap.core.admin.server.password.cmd.util.ConsoleUtil;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Parameters(commandDescription="Lists the passwords put into password storage for a given application")
public class ListPasswordCommand
extends OrchestratorRemoteCommand {
    @Parameter(names={"-b", "-application", "--application"}, description="Name of the application you want to manage, configure, or deploy")
    String application;
    @Parameter(names={"-t", "-tenant", "--tenant"}, description="Tenant-isolated application process for the given tenant", hidden=true)
    String tenant;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() throws CommandException {
        if (this.tenant == null || this.tenant.equals("")) {
            this.tenant = "NULL";
        }
        if (!ConsoleUtil.checkArgSpecified("-a", "--account", this.account) || !ConsoleUtil.checkArgSpecified("-b", "--application", this.application)) throw new CommandException("Invalid parameters", 109);
        this.dumpParameters("list-passwords", this.application);
        try {
            OrchestratorClient client = OrchestratorClientImpl.getOrchestratorClient(this.account, this.httpClient);
            OrchestratorResult orchestratorResult = client.listPasssword(this.application, this.tenant, this.host);
            OrchestratorDumpHelper.printAndCheckOrchestratorResult("list-password", orchestratorResult, 125, false);
            if (orchestratorResult.getCode() != 0) return;
            this.printPassowrds(orchestratorResult.getPasswords(), this.application);
            return;
        }
        catch (Exception e) {
            throw new CommandException("list-password failed", e, 121);
        }
    }

    private void printPassowrds(List<Password> passwords, String applicationName) {
        int max = "ALIAS".length();
        int max1 = "VALUE HASH".length();
        int max2 = "STATUS".length();
        for (Password password : passwords) {
            int length = password.getAlias().length();
            if (length > max) {
                max = length;
            }
            if ((length = password.getHash().length()) > max1) {
                max1 = length;
            }
            if ((length = password.getStatus().length()) <= max2) continue;
            max2 = length;
        }
        if (passwords.size() != 0) {
            ListPasswordCommand.dumpWithNewLine("Passwords list: ");
            String formatString = "   %-" + max + "s : %-" + max1 + "s : %-" + max2 + "s";
            ListPasswordCommand.dump(String.format(formatString, "ALIAS", "VALUE HASH", "STATUS"));
            ListPasswordCommand.dump("");
            for (Password password : passwords) {
                ListPasswordCommand.dump(String.format(formatString, password.getAlias(), password.getHash(), password.getStatus()));
            }
            ListPasswordCommand.dump("");
        } else {
            ListPasswordCommand.dump("--- No passwords into storage for application " + applicationName + "---");
        }
    }

    public void dumpParameters(String operation, String application) {
        ArrayList argsList = new ArrayList();
        Collections.addAll(argsList, "subaccount", this.account, "application", application, "host", this.host);
        DumpHelper.dumpOperationList(this.user, "Requesting " + operation + " for:", argsList.toArray());
    }

    @Override
    public String getName() {
        return "list-passwords";
    }

    private static void dumpWithNewLine(String message) {
        ListPasswordCommand.dump("");
        ListPasswordCommand.dump(message);
    }

    private static void dump(String message) {
        System.out.println(message);
    }
}

