/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.admin.server.password.cmd.commands;

import com.sap.core.admin.server.password.cmd.util.BasicAuthHttpClientProvider;
import com.sap.jpaas.infrastructure.console.command.RemoteCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import java.util.Properties;
import org.apache.http.client.HttpClient;

public abstract class OrchestratorConsoleCommand
extends RemoteCommand<Object> {
    HttpClient httpClient;
    Properties httpClientProperties = new Properties();

    @Override
    public void init() throws CommandException {
        super.initWithNoPasswordCheck();
        this.askForPasswordAndInitHttpClient();
    }

    @Override
    public void cleanup() throws CommandException {
        if (this.httpClient != null) {
            this.httpClient.getConnectionManager().shutdown();
        }
    }

    @Override
    public String getGroup() {
        return "password-storage";
    }

    public void askForPasswordAndInitHttpClient() {
        if (this.httpClient == null) {
            try {
                this.httpClientProperties.setProperty("URL", this.host);
                this.httpClientProperties.setProperty("User", this.user);
                this.httpClientProperties.setProperty("Password", this.getPassword());
                this.httpClient = BasicAuthHttpClientProvider.createHttpClient(this.httpClientProperties);
            }
            catch (Exception e) {
                throw new HelpException("Cannot initialize HTTP client", e, 101);
            }
        }
    }

    @Override
    public HttpClient getHttpClient() {
        return this.httpClient;
    }
}

