/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.admin.server.password.cmd.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.admin.server.password.cmd.client.OrchestratorClient;
import com.sap.core.admin.server.password.cmd.client.OrchestratorClientImpl;
import com.sap.core.admin.server.password.cmd.client.OrchestratorDumpHelper;
import com.sap.core.admin.server.password.cmd.client.OrchestratorResult;
import com.sap.core.admin.server.password.cmd.client.PasswordChecker;
import com.sap.core.admin.server.password.cmd.commands.OrchestratorRemoteCommand;
import com.sap.core.admin.server.password.cmd.util.ConsoleUtil;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.util.ArrayList;
import java.util.Collections;

@Parameters(commandDescription="Sets and puts into password storage an alias and a password for a given application.\n Password should not be smaller than 6 characters and no bigger than 255 characters.")
public class SetPasswordCommand
extends OrchestratorRemoteCommand {
    @Parameter(names={"-b", "-application", "--application"}, description="Name of the application you want to manage, configure, or deploy")
    String application;
    @Parameter(names={"-t", "-tenant", "--tenant"}, description="Tenant-isolated application process for the given tenant", hidden=true)
    String tenant;
    @Parameter(names={"--alias"}, description="A word or short phrase that identifies the password and will help you recognize the password later when you list the passwords into the password storage")
    String passwordName;
    String passwordValue;
    String passwordRepeat;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() throws CommandException {
        if (this.tenant == null || this.tenant.equals("")) {
            this.tenant = "NULL";
        }
        if (!ConsoleUtil.checkArgSpecified("-a", "--account", this.account) || !ConsoleUtil.checkArgSpecified("-b", "--application", this.application) || !ConsoleUtil.checkArgSpecified(null, "--alias", this.passwordName)) throw new CommandException("Invalid parameters", 109);
        this.passwordValue = PasswordChecker.checkPassword(this.passwordValue, "Enter value for password with alias " + this.passwordName + ": ");
        this.passwordRepeat = PasswordChecker.checkPassword(this.passwordRepeat, "Repeat value for password with alias " + this.passwordName + ": ");
        if (!this.passwordValue.equals(this.passwordRepeat)) {
            throw new CommandException("Passwords does not match", null, 121);
        }
        if (!ConsoleUtil.checkArgSpecified(null, "--value", this.passwordValue)) throw new CommandException("Invalid parameters", 109);
        this.dumpParameters("set-password", this.application, this.passwordName);
        try {
            OrchestratorClient client = OrchestratorClientImpl.getOrchestratorClient(this.account, this.httpClient);
            OrchestratorResult orchestratorResult = client.setPassword(this.application, this.tenant, this.passwordName, this.passwordValue, this.host);
            OrchestratorDumpHelper.printAndCheckOrchestratorResult("set-password", orchestratorResult, 125, false);
            return;
        }
        catch (Exception e) {
            throw new CommandException("set-password failed", e, 121);
        }
    }

    public void dumpParameters(String operation, String application, String passwordName) {
        ArrayList argsList = new ArrayList();
        Collections.addAll(argsList, "subaccount", this.account, "application", application, "host", this.host, "alias", passwordName);
        DumpHelper.dumpOperationList(this.user, "Requesting " + operation + " for:", argsList.toArray());
    }

    @Override
    public String getName() {
        return "set-password";
    }
}

