/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.resources.filemanagement.cmd;

import com.beust.jcommander.ParameterException;
import com.sap.cloud.resources.filemanagement.client.AuthenticationException;
import com.sap.cloud.resources.filemanagement.client.ResourceManager;
import com.sap.cloud.resources.filemanagement.client.ResourceManagerFactory;
import com.sap.cloud.resources.filemanagement.client.ResourceOperationException;
import com.sap.cloud.resources.filemanagement.client.UnauthorizedException;
import com.sap.cloud.resources.filemanagement.cmd.Constants;
import com.sap.jpaas.infrastructure.console.command.AccountCommand;
import com.sap.jpaas.infrastructure.console.exception.BackendException;
import com.sap.jpaas.infrastructure.console.exception.FrontendException;
import com.sap.jpaas.infrastructure.console.exception.SecurityException;
import com.sap.jpaas.infrastructure.console.exception.ValidationException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.http.client.HttpClient;
import org.apache.log4j.Logger;

public abstract class AbstractResourceCommand
extends AccountCommand {
    private static final Logger LOGGER = Logger.getLogger(AbstractResourceCommand.class);
    protected HttpClient httpClient;

    public void run() {
        this.checkArguments();
        this.dumpOperation();
        try {
            this.execute();
        }
        catch (UnauthorizedException ex) {
            LOGGER.error((Object)"Authorization failed", (Throwable)ex);
            throw new ValidationException(Constants.MSG_AUTHORIZATION_FAILED);
        }
        catch (AuthenticationException ex) {
            LOGGER.error((Object)"Authentication failed", (Throwable)ex);
            throw new SecurityException("Wrong user name or password");
        }
        catch (ResourceOperationException ex) {
            LOGGER.error((Object)"Command execution failed", (Throwable)ex);
            throw new BackendException("Cannot execute command. Try again later and if the issue persists contact SAP support.");
        }
    }

    public void cleanup() {
        if (this.httpClient != null) {
            this.httpClient.getConnectionManager().shutdown();
        }
    }

    public String getGroup() {
        return "resources";
    }

    protected abstract void execute() throws ResourceOperationException;

    protected void checkArguments() throws ParameterException {
        CheckHelper.checkArgSpecified((String)"-a", (String)"--account", (String)this.account);
    }

    protected String[] getDumpArguments() {
        return new String[0];
    }

    protected ResourceManager getResourceManager() throws FrontendException {
        this.httpClient = this.getHttpClient();
        try {
            return this.getResourceManagerFactory().createResourceManager(this.httpClient, new URL(this.getHost()), this.getAccount());
        }
        catch (MalformedURLException e) {
            LOGGER.error((Object)"Invalid ladscape host. It should have been validated", (Throwable)e);
            throw new FrontendException("Invalid landscape host", (Throwable)e);
        }
    }

    protected ResourceManagerFactory getResourceManagerFactory() {
        return ResourceManagerFactory.getInstance();
    }

    protected HttpClient getHttpClient() throws ValidationException {
        return this.getHttpClient("/", 20000);
    }

    protected void dump(String pattern, Object ... arguments) {
        DumpHelper.dumpWithNewLine((String)this.format(pattern, arguments));
    }

    protected String format(String pattern, Object ... arguments) {
        return MessageFormat.format(pattern, arguments);
    }

    private void dumpOperation() {
        ArrayList<String> args = new ArrayList<String>();
        Collections.addAll(args, "host", this.getHost(), "account", this.getAccount());
        for (String arg : this.getDumpArguments()) {
            args.add(arg);
        }
        DumpHelper.dumpOperationList((String)this.getUser(), (String)this.format("Requesting {0} with arguments:", this.getName()), (Object[])args.toArray());
    }
}

