/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.resources.filemanagement.cmd;

import com.sap.cloud.resources.filemanagement.client.BasicResourceInfo;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class BasicResourceInfoFormatter {
    private static final String[] SIZE_MEASUREMENT_UNITS = new String[]{"B", "KB", "MB"};
    private SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yyyy", Locale.ENGLISH);

    public String getLastModified(BasicResourceInfo info) {
        return this.dateFormat.format(new Date(info.getLastModified()));
    }

    public String getSize(BasicResourceInfo info) {
        int unitIndex;
        long size = info.getSize();
        int DIVISION_UNIT = 1024;
        for (unitIndex = 0; size > 1024L && unitIndex < SIZE_MEASUREMENT_UNITS.length - 1; ++unitIndex) {
            size = Math.round((double)size / 1024.0);
        }
        return String.valueOf(size) + " " + SIZE_MEASUREMENT_UNITS[unitIndex];
    }
}

