/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.resources.filemanagement.cmd;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;

public class ConsoleTable {
    private List<Column> columns;
    private List<String[]> rows;
    private String[] header;

    public ConsoleTable(Column[] columns) {
        this.columns = Arrays.asList(columns);
        this.rows = new ArrayList<String[]>();
        this.header = new String[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            this.header[i] = columns[i].getName();
        }
    }

    public void addRow(String ... cells) {
        this.rows.add(cells);
        this.calculateColumnWidths();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(PrintStream out) {
        String headerPattern = this.buildHeaderPattern();
        String pattern = this.buildPattern();
        Formatter formatter = null;
        try {
            formatter = new Formatter(out);
            formatter.format(headerPattern, this.header);
            for (String[] row : this.rows) {
                formatter.format(pattern, row);
            }
        }
        finally {
            if (null != formatter) {
                formatter.close();
            }
        }
    }

    private String buildPattern() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.columns.size(); ++i) {
            Column column = this.columns.get(i);
            this.appendSpaces(buf, column.getLeftPadding() + column.getTrailingSpaces());
            buf.append('%').append(i + 1).append('$');
            if (column.getAlignment() == Alignment.LEFT) {
                buf.append('-');
            }
            buf.append(column.getWidth()).append('s');
            this.appendSpaces(buf, this.header[i].length() - column.getWidth() - column.getTrailingSpaces());
        }
        buf.append("\n");
        return buf.toString();
    }

    private String buildHeaderPattern() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.columns.size(); ++i) {
            Column column = this.columns.get(i);
            this.appendSpaces(buf, column.getLeftPadding());
            buf.append('%').append(i + 1).append("$-");
            int width = column.getWidth();
            if (column.getWidth() > this.header[i].length()) {
                width += column.getTrailingSpaces();
            }
            buf.append(width).append('s');
        }
        buf.append("\n");
        return buf.toString();
    }

    private void calculateColumnWidths() {
        String[] lastRow = this.rows.get(this.rows.size() - 1);
        for (int i = 0; i < lastRow.length; ++i) {
            String string = lastRow[i];
            Column column = this.columns.get(i);
            if (string.length() <= column.getWidth()) continue;
            column.setWidth(string.length());
        }
    }

    private void appendSpaces(StringBuilder buf, int count) {
        for (int i = 0; i < count; ++i) {
            buf.append(' ');
        }
    }

    public static class Column {
        private String name;
        private Alignment alignment;
        private int width;
        private int trailingSpaces;
        private int leftPadding;

        public Column(String name, Alignment alignment, int trailingSpaces, int leftPadding) {
            this.name = name;
            this.alignment = alignment;
            this.leftPadding = leftPadding;
            this.trailingSpaces = trailingSpaces;
        }

        public String getName() {
            return this.name;
        }

        public Alignment getAlignment() {
            return this.alignment;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getTrailingSpaces() {
            return this.trailingSpaces;
        }

        public int getLeftPadding() {
            return this.leftPadding;
        }
    }

    public static enum Alignment {
        LEFT,
        RIGHT;

    }
}

