/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.resources.filemanagement.cmd;

public class Constants {
    private static final String LINE_SEPARATOR = "line.separator";
    private static final String AUTHORIZATION_FAILED_MSG = "Authorization failed. Check if:%s1. the account name and the host are correct%s2. the provided user has rights to perform the operation in the specified account";
    public static final String GROUP_NAME = "resources";
    public static final String COMMAND_DELETE_RESOURCE = "delete-resource";
    public static final String COMMAND_DELETE_RESOURCE_DESCR = "BETA: Deletes a specified resource from the system repository";
    public static final String COMMAND_LIST_RESOURCES = "list-resources";
    public static final String COMMAND_LIST_RESOURCES_DESCR = "BETA: Lists the resources for the specified account";
    public static final String COMMAND_UPLOAD_RESOURCE = "upload-resource";
    public static final String COMMAND_UPLOAD_RESOURCE_DESCR = "BETA: Uploads a resource to the system repository of the specified account";
    public static final String PARAM_NAME_SHORT = "-n";
    public static final String PARAM_NAME_LONG = "--name";
    public static final String PARAM_DELETE_RES_NAME_DESCR = "BETA: Resource name";
    public static final String PARAM_UPLOAD_RES_NAME_DESCR = "BETA: Resource name. If you do not explicitly specify it, the file name of the resource will be used.";
    public static final String PARAM_SILENT_SHORT = "-s";
    public static final String PARAM_SILENT_LONG = "--silent";
    public static final String PARAM_SILENT_DESCR = "BETA: Suppresses the command-line confirmation prompt";
    public static final String PARAM_LOCATION_SHORT = "-l";
    public static final String PARAM_LOCATION_LONG = "--location";
    public static final String PARAM_LOCATION_DESCR = "BETA: Path to the resource file in the local file system. Supported file formats are ZIP and GZIP.";
    public static final String PARAM_OVERWRITE_SHORT = "-w";
    public static final String PARAM_OVERWRITE_LONG = "--overwrite";
    public static final String PARAM_OVERWRITE_DESCR = "BETA: If a resource with the same name already exists, overwrite it. If you do not specify --overwrite, you will be asked if you want to overwrite the resource.";
    public static final String MSG_DUMP = "Requesting {0} with arguments:";
    public static final String MSG_AUTHENTICATION_FAILED = "Wrong user name or password";
    public static final String MSG_AUTHORIZATION_FAILED = Constants.getGenericAuthorizationFailedMsg();
    public static final String MSG_GENERAL_EXCEPTION = "Cannot execute command. Try again later and if the issue persists contact SAP support.";
    public static final String MSG_RESOURCE_DELETED = "Resource deleted: ''{0}''";
    public static final String MSG_CONFIRM_DELETION = "Confirm that you want to delete resource ''{0}'': y/n ";
    public static final String MSG_RESOURCE_NOT_FOUND = "Resource ''{0}'' not found in account ''{1}''";
    public static final String MSG_RESOURCE_UPLOADER = "Resource uploaded: ''{0}''";
    public static final String MSG_UPLOAD_RESOURCE_NOT_FOUND = "Invalid value in parameter --location. File ''{0}'' was not found.";
    public static final String MSG_UPLOAD_FILE_IS_DIR = "The provided value for --location points to a directory. The value must point to a file.";
    public static final String MSG_UPLOAD_INVALID_FILE_NAME = "File name of the resource must be in English. Rename the file or specify the --name argument using characters from the following ranges: 'a' - 'z', 'A' - 'Z', '0' - '9', '.', '-'";
    public static final String MSG_UPLOAD_INVALID_RESOURCE_NAME = "Invalid value in parameter --name. Resource name can contain characters from the following ranges: 'a' - 'z', 'A' - 'Z', '0' - '9', '.', '/', '-'";
    public static final String MSG_CONFIRM_OVERWRITE = "Resource ''{0}'' already exists in the repository. Do you want to overwrite it? y/n ";
    public static final String MSG_NO_RESOURCES_FOUND = "No resources found in account ''{0}''";
    public static final String MSG_RESOURCE_LIST_HEADER = "Resources";
    public static final String HEADER_RESOURCE = "Resource";
    public static final String HEADER_DATE_MODIFIED = "Date Modified";
    public static final String HEADER_SIZE = "Size";
    public static final char CONTINUE_CHARACTER = 'y';

    private static String getGenericAuthorizationFailedMsg() {
        String lineSeparator = System.getProperty(LINE_SEPARATOR);
        return String.format(AUTHORIZATION_FAILED_MSG, lineSeparator, lineSeparator);
    }
}

