/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.resources.filemanagement.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.cloud.resources.filemanagement.client.ResourceManager;
import com.sap.cloud.resources.filemanagement.client.ResourceNotFoundException;
import com.sap.cloud.resources.filemanagement.client.ResourceOperationException;
import com.sap.cloud.resources.filemanagement.cmd.AbstractResourceCommand;
import com.sap.cloud.resources.filemanagement.cmd.ActionConfirmer;
import com.sap.cloud.resources.filemanagement.cmd.io.ConsoleInputReader;
import com.sap.jpaas.infrastructure.console.exception.BackendException;
import com.sap.jpaas.infrastructure.console.exception.FrontendException;
import com.sap.jpaas.infrastructure.console.model.Hidden;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;
import org.apache.log4j.Logger;

@Hidden
@Parameters(commandDescription="BETA: Deletes a specified resource from the system repository")
public class DeleteResourceCommand
extends AbstractResourceCommand {
    private static final Logger LOGGER = Logger.getLogger(DeleteResourceCommand.class);
    @Parameter(names={"-n", "--name"}, description="BETA: Resource name")
    private String resName;
    @Parameter(names={"-s", "--silent"}, description="BETA: Suppresses the command-line confirmation prompt")
    private boolean silent;

    @Override
    protected void execute() throws ResourceOperationException {
        if (!this.confirmDeletion()) {
            return;
        }
        try {
            ResourceManager rm = this.getResourceManager();
            rm.delete(this.resName);
            this.dump("Resource deleted: ''{0}''", this.resName);
        }
        catch (ResourceNotFoundException ex) {
            LOGGER.error((Object)"Resource not found", (Throwable)ex);
            throw new BackendException(this.format("Resource ''{0}'' not found in account ''{1}''", this.resName, this.getAccount()));
        }
    }

    @Override
    protected void checkArguments() {
        super.checkArguments();
        CheckHelper.checkArgSpecified((String)"-n", (String)"--name", (String)this.resName);
    }

    public String getName() {
        return "delete-resource";
    }

    @Override
    protected String[] getDumpArguments() {
        return new String[]{"name", this.resName, "silent", Boolean.toString(this.silent)};
    }

    private boolean confirmDeletion() throws FrontendException {
        if (this.silent) {
            return true;
        }
        ActionConfirmer confirmer = this.createConfirmer();
        return confirmer.confirm();
    }

    ActionConfirmer createConfirmer() {
        ConsoleInputReader ir = new ConsoleInputReader(System.console());
        return new ActionConfirmer('y', this.format("Confirm that you want to delete resource ''{0}'': y/n ", this.resName), ir);
    }
}

