/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.resources.filemanagement.cmd;

import com.beust.jcommander.Parameters;
import com.sap.cloud.resources.filemanagement.client.BasicResourceInfo;
import com.sap.cloud.resources.filemanagement.client.ResourceManager;
import com.sap.cloud.resources.filemanagement.client.ResourceOperationException;
import com.sap.cloud.resources.filemanagement.cmd.AbstractResourceCommand;
import com.sap.cloud.resources.filemanagement.cmd.BasicResourceInfoFormatter;
import com.sap.cloud.resources.filemanagement.cmd.ConsoleTable;
import com.sap.jpaas.infrastructure.console.model.Hidden;

@Hidden
@Parameters(commandDescription="BETA: Lists the resources for the specified account")
public class ListResourcesCommand
extends AbstractResourceCommand {
    public String getName() {
        return "list-resources";
    }

    @Override
    protected void execute() throws ResourceOperationException {
        ResourceManager rm = this.getResourceManager();
        BasicResourceInfo[] resourceInfos = rm.list();
        if (resourceInfos.length > 0) {
            this.printList(resourceInfos);
        } else {
            this.dump("No resources found in account ''{0}''", this.getAccount());
        }
    }

    private void printList(BasicResourceInfo[] resourceInfos) {
        ConsoleTable table = this.createConsoleTable();
        BasicResourceInfoFormatter formatter = new BasicResourceInfoFormatter();
        for (BasicResourceInfo resourceInfo : resourceInfos) {
            table.addRow(resourceInfo.getFilePath(), formatter.getLastModified(resourceInfo), formatter.getSize(resourceInfo));
        }
        this.dump("Resources", new Object[0]);
        table.print(System.out);
    }

    private ConsoleTable createConsoleTable() {
        ConsoleTable.Column[] columns = new ConsoleTable.Column[]{new ConsoleTable.Column("Resource", ConsoleTable.Alignment.LEFT, 2, 0), new ConsoleTable.Column("Date Modified", ConsoleTable.Alignment.RIGHT, 2, 3), new ConsoleTable.Column("Size", ConsoleTable.Alignment.RIGHT, 2, 3)};
        return new ConsoleTable(columns);
    }
}

