/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.resources.filemanagement.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.cloud.resources.filemanagement.client.ResourceManager;
import com.sap.cloud.resources.filemanagement.client.ResourceOperationException;
import com.sap.cloud.resources.filemanagement.client.UnauthorizedException;
import com.sap.cloud.resources.filemanagement.cmd.AbstractResourceCommand;
import com.sap.cloud.resources.filemanagement.cmd.ActionConfirmer;
import com.sap.cloud.resources.filemanagement.cmd.io.ConsoleInputReader;
import com.sap.cloud.resources.filemanagement.cmd.util.StringUtils;
import com.sap.cloud.resources.filemanagement.cmd.validation.DirectoryCheck;
import com.sap.cloud.resources.filemanagement.cmd.validation.FileExistenceCheck;
import com.sap.cloud.resources.filemanagement.cmd.validation.InvalidFilenameCheck;
import com.sap.cloud.resources.filemanagement.cmd.validation.InvalidResourceNameCheck;
import com.sap.cloud.resources.filemanagement.cmd.validation.ResourceCheck;
import com.sap.cloud.resources.filemanagement.cmd.validation.ResourceFileValidationException;
import com.sap.jpaas.infrastructure.console.exception.ValidationException;
import com.sap.jpaas.infrastructure.console.model.Hidden;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;
import java.io.File;
import org.apache.log4j.Logger;

@Hidden
@Parameters(commandDescription="BETA: Uploads a resource to the system repository of the specified account")
public class UploadResourceCommand
extends AbstractResourceCommand {
    private static final Logger LOGGER = Logger.getLogger(UploadResourceCommand.class);
    @Parameter(names={"-n", "--name"}, description="BETA: Resource name. If you do not explicitly specify it, the file name of the resource will be used.")
    private String providedResourceName;
    @Parameter(names={"-l", "--location"}, description="BETA: Path to the resource file in the local file system. Supported file formats are ZIP and GZIP.")
    private String location;
    @Parameter(names={"-w", "--overwrite"}, description="BETA: If a resource with the same name already exists, overwrite it. If you do not specify --overwrite, you will be asked if you want to overwrite the resource.")
    private boolean overwrite;
    private final ResourceCheck resCheckChain;
    private ResourceManager rm;
    private String resourceName;
    private File resourceLocation;

    public UploadResourceCommand() {
        this.resCheckChain = this.createResCheckChain();
    }

    UploadResourceCommand(ResourceCheck resCheckChain) {
        this.resCheckChain = resCheckChain;
    }

    private ResourceCheck createResCheckChain() {
        FileExistenceCheck fileExistenceCheck = new FileExistenceCheck();
        DirectoryCheck dirCheck = new DirectoryCheck();
        fileExistenceCheck.setNext(dirCheck);
        return fileExistenceCheck;
    }

    public String getName() {
        return "upload-resource";
    }

    @Override
    protected String[] getDumpArguments() {
        return new String[]{"name", this.providedResourceName, "location", this.location, "overwrite", Boolean.toString(this.overwrite)};
    }

    @Override
    protected void checkArguments() {
        super.checkArguments();
        CheckHelper.checkArgSpecified((String)"-l", (String)"--location", (String)this.location);
        this.resourceLocation = new File(this.location);
        this.resourceName = StringUtils.isEmpty(this.providedResourceName) ? this.resourceLocation.getName() : this.providedResourceName;
        this.validateResourceFile();
        this.validateResourceName();
    }

    @Override
    protected void execute() throws UnauthorizedException, ResourceOperationException {
        this.rm = this.getResourceManager();
        try {
            if (this.continueWithUpload()) {
                this.rm.upload(this.resourceName, this.resourceLocation);
                this.dump("Resource uploaded: ''{0}''", this.resourceName);
            }
        }
        catch (com.sap.cloud.resources.filemanagement.client.ValidationException ex) {
            LOGGER.error((Object)("Failed to upload resource with name " + this.resourceName), (Throwable)ex);
            throw new ValidationException(ex.getMessage());
        }
    }

    private void validateResourceFile() {
        try {
            this.resCheckChain.validate(this.location);
        }
        catch (ResourceFileValidationException ex) {
            LOGGER.error((Object)this.format("The provided file {0} is invalid.", this.location), (Throwable)ex);
            throw new ValidationException(ex.getMessage());
        }
    }

    private void validateResourceName() {
        try {
            if (StringUtils.isEmpty(this.providedResourceName)) {
                new InvalidFilenameCheck().validate(this.location);
            } else {
                new InvalidResourceNameCheck().validate(this.resourceName);
            }
        }
        catch (ResourceFileValidationException e) {
            LOGGER.error((Object)("Invalid resource name: " + this.resourceName), (Throwable)e);
            throw new ValidationException(e.getMessage());
        }
    }

    private boolean continueWithUpload() throws UnauthorizedException, ResourceOperationException {
        if (this.overwrite) {
            return true;
        }
        if (!this.rm.exists(this.resourceName)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Resource does not exist.");
            }
            return true;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Resource already exists. Will ask for confirmation");
        }
        return this.confirmOverwrite();
    }

    private boolean confirmOverwrite() {
        ConsoleInputReader ir = new ConsoleInputReader(System.console());
        ActionConfirmer confirmer = new ActionConfirmer('y', this.format("Resource ''{0}'' already exists in the repository. Do you want to overwrite it? y/n ", this.resourceName), ir);
        return confirmer.confirm();
    }
}

